<?php

namespace InternetGalerie\Igshop2\User;

use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class PropertyValueDisplayCond
{
    public function evaluate($params)
    {
        $fieldName = $params['conditionParameters'][0];
        $record = $params['record'];
        if (isset($record['property'])) {
            $qb = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
                'tx_igshop2_domain_model_property'
            );
            $propertyUid = $record['property'][0][0];
            if ($propertyUid) {
                $propertyInDb = $qb->select('field_type')
                                ->from('tx_igshop2_domain_model_property')
                                ->where('uid = ' . $propertyUid)
                                ->andWhere('deleted = 0')
                                    ->andWhere('sys_language_uid IN (0, -1)')
                                ->executeQuery()
                                ->fetchAssociative();

                if ($propertyInDb) {
                    $valueField = $this->getValueFieldName($propertyInDb);
                    if (!is_null($valueField) && $valueField == $fieldName) {
                        return true;
                    }
                }
            }
        }

        return false;
    }

    protected function getValueFieldName($property)
    {
        return match ($property['field_type']) {
            'Checkbox', 'Float' => 'property_value_number',
            'Textarea', 'Rte' => 'property_value_textarea',
            default => 'property_value',
        };
    }
}
