<?php

namespace InternetGalerie\Igshop2\Utility;

use Ig\IgPayment\Services\PaymentService;
use Ig\IgPayment\Utility\PaymentUtility;
use InternetGalerie\Igshop2\Domain\Model\Cart;
use TYPO3\CMS\Core\SingletonInterface;
use InternetGalerie\Igshop2\Domain\Model\Order;
use InternetGalerie\Igshop2\Domain\Model\Country;
use InternetGalerie\Igshop2\Domain\Model\FeUser;
use InternetGalerie\Igshop2\Domain\Repository\CountryRepository;
use InternetGalerie\Igshop2\Domain\Repository\CartProductRepository;
use InternetGalerie\Igshop2\Domain\Repository\CartRepository;
use InternetGalerie\Igshop2\Domain\Repository\FeUserRepository;
use InternetGalerie\Igshop2\Domain\Repository\OrderProductRepository;
use InternetGalerie\Igshop2\Domain\Repository\OrderRepository;
use InternetGalerie\Igshop2\Domain\Repository\PortoRepository;
use InternetGalerie\Igshop2\Domain\Repository\ProductRepository;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;

class CartUtility implements SingletonInterface
{
    /**
     * the current cart
     *
     * @var Cart
     */
    public $cart = null;

    /**
     * the current order
     *
     * @var Order
     */
    public $order = null;

    /**
     * @var string Name of the extension this view helper belongs to
     */
    protected $extensionName = 'IgShop2';

    /**
     * @var string Name of the extension this view helper belongs to (ext_localconf.php configurePlugin zweites  Argument)
     */
    protected $pluginName = 'igshop2';

    /**
     * cartRepository
     *
     * @var CartRepository
     */
    protected $cartRepository = null;

    /**
     * cartRepository
     *
     * @var OrderRepository
     */
    protected $orderRepository = null;

    /**
     * productRepository
     *
     * @var ProductRepository
     **/
    protected $productRepository = null;

    /**
     * CartProductRepository
     *
     * @var CartProductRepository
     */
    protected $cartProductRepository = null;

    /**
     * OrderProductRepository
     *
     * @var OrderProductRepository
     */
    protected $orderProductRepository = null;

    /**
     * countryRepository
     *
     * @var CountryRepository
     */
    protected $countryRepository = null;

    /**
     * portoRepository
     *
     * @var PortoRepository
     */
    protected $portoRepository = null;

    /**
     * portoRepository
     *
     * @var FeUserRepository
     */
    protected $feUserRepository = null;


    /**
     * @var ConfigurationManagerInterface
     */
    protected $configurationManager;


    protected PaymentUtility $paymentUtility;
    
    /**
     * country used just for default ? [DA] @todo remove
     *
     * @var Country
     */
    protected $country = null;

    protected ?FeUser $feUser;

    protected $settings = null;


    public function injectConfigurationManager(ConfigurationManagerInterface $configurationManager): void
    {
        $this->configurationManager = $configurationManager;
        $this->settings = $this->configurationManager->getConfiguration(
            ConfigurationManagerInterface::CONFIGURATION_TYPE_SETTINGS,
            $this->extensionName,
            $this->pluginName
        );
    }

    public function injectPaymentUtility(PaymentUtility $paymentUtility): void
    {
        $this->paymentUtility = $paymentUtility;
    }

    public function injectCartRepository(CartRepository $cartRepository): void
    {
        $this->cartRepository = $cartRepository;
    }

    public function injectOrderRepository(OrderRepository $orderRepository): void
    {
        $this->orderRepository = $orderRepository;
    }

    public function injectProductRepository(ProductRepository $productRepository): void
    {
        $this->productRepository = $productRepository;
    }

    public function injectCartProductRepository(CartProductRepository $cartProductRepository): void
    {
        $this->cartProductRepository = $cartProductRepository;
    }

    public function injectOrderProductRepository(OrderProductRepository $orderProductRepository): void
    {
        $this->orderProductRepository = $orderProductRepository;
    }


    public function injectCountryRepository(CountryRepository $countryRepository): void
    {
        $this->countryRepository = $countryRepository;
    }


    public function injectPortoRepository(PortoRepository $portoRepository): void
    {
        $this->portoRepository = $portoRepository;
    }


    public function injectFeUserRepository(FeUserRepository $feUserRepository): void
    {
        $this->feUserRepository = $feUserRepository;
    }

    /**
     * Aktueller Warenkorb laden
     */
    public function initializeObject(): void
    {
        $context = GeneralUtility::makeInstance(Context::class);
        $userId = $context->getPropertyFromAspect('frontend.user', 'id');
        $this->country = $this->countryRepository->getCountryFromRemoteAddr($_SERVER['REMOTE_ADDR']);
        $currency = $this->country->getCurrency();
        $this->feUser = $userId ? $this->feUserRepository->findByUid($userId) : null;
        $this->cart = $this->cartRepository->getCurrent($currency, $this->feUser);
        if($this->feUser) {
            $this->feUser->setCurrentOrder($this->cart);
            $this->feUserRepository->update($this->feUser);
        }
    }

    // OrderController.php ist doch in order drin??????
    public function getCountry()
    {
        return $this->country;
    }

    public function getCartByUid($uid): void
    {
        $this->cart = $this->cartRepository->findByUid($uid);
    }

    public function getOrderByUid($uid): void
    {
        $this->order = $this->orderRepository->findByUid($uid);
    }


    // von ProductController.php fuer Waehrung ???
    /*
    public function getCurrency(Currency $currency)
    {
        $this->getCart( $currency );
        return $this->cart->getCurrency();
    }
    */

    public function addProduct($product, $options = []): void
    {
        $this->cart->addNewProduct($product, $this->settings['prodLimit'] ?? null, $options);
    }

    public function addProductByUid(int $productUid, $options = []): void
    {
        $product = $this->productRepository->findByUid($productUid);
        $this->addProduct($product, $options);
    }

    public function removeCartProduct($cartProduct): void
    {
        $this->cart->removeProduct($cartProduct);
    }

    public function removeCartProductByUid(int $cartProductUid, $options = []): void
    {
        $cartProduct = $this->cartProductRepository->findByUid($cartProductUid);
        if (is_object($cartProduct)) {
            $cartProduct->setAmount(0);
            $this->cartProductRepository->update($cartProduct);
            $this->removeCartProduct($cartProduct);
        }
    }

    public function removeOrderProduct($orderProduct): void
    {
        $this->order->removeProduct($orderProduct);
    }

    public function removeOrderProductByUid(int $orderProductUid, $options = []): void
    {
        $orderProduct = $this->orderProductRepository->findByUid($orderProductUid);
        if (is_object($orderProduct)) {
            $orderProduct->setAmount(0);
            $this->orderProductRepository->update($orderProduct);
            $this->removeOrderProduct($orderProduct);
        }
    }

    public function cartProductSetQuantity($cartProduct, $quantity)
    {
        return $this->cart->changeProductQuantity($cartProduct, $quantity);
    }

    public function cartProductSetQuantityByUid(int $cartProductUid, $quantity)
    {
        $cartProduct = $this->cartProductRepository->findByUid($cartProductUid);
        if (is_object($cartProduct)) {
            return $this->cartProductSetQuantity($cartProduct, $quantity);
        }

        return false;
    }

    // Bestellung ist mit Porto?
    public function hasPorto()
    {
        $paymentMethod = $this->cart->getPaymentMethod();
        // Ist Bestellung ohne Porto
        if (!$paymentMethod || $paymentMethod->getNoPorto() || $this->cart->hasProductWithoutPorto()) {
            return false;
        }

        return true;
    }

    public function setPorto($portoUid): void
    {
        if ($this->hasPorto()) {
            $country = $this->cart->getCountry();
            if ($portoUid > 0) {
                $porto = $this->portoRepository->findByUid($portoUid);
                if (is_object($porto) && $this->cart->isPortoValidWithCountry($country)) {
                    $this->cart->setPorto($porto);
                    $this->update();
                    return;
                }

                // no valid porto -> Fehler ?!
                //$this->cart->removePorto();
            }

            $this->setDefaultPorto($country);
        } else {
            $this->cart->removePorto();
        }
    }

    // Default Porto setzen falls leer -> wirklich noetig? [DA]
    public function setDefaultPorto($country = null): void
    {
        if ($country === null) {
            // @todo Mist - warum Porto mit Uid=1 [DA]  fuer OrderController showAction
            $porto = $this->portoRepository->findByUid(1);
        } else {
            // @todo neu $this->shop->getDefaultPortoForCountry($country)
            $porto = $this->portoRepository->getDefaultPortoForCountry($country);
        }

        if (is_object($porto)) {
            $this->cart->setPorto($porto);
            $this->update();
        } else {
            // ist eh leer oder ungueltig?
            $this->cart->removePorto();
        }
    }

    public function getAvailablePortos()
    {
        if ($this->hasPorto()) {
            $country = $this->cart->getCountry();
            // @todo neu $this->shop->getPortosForCountry($country)
            return $this->portoRepository->getAllForCountry($country);
        }

        return [];
    }

    public function setSubmitted($submitted): void
    {
        $this->cart->setSubmitted($submitted);
        if($this->order !== null) {
            $this->order->setSubmitted($submitted);
        }
    }

    public function update($updatePayment = true): void
    {
        $this->cartRepository->persist($this->cart);
        if($this->order !== null) {
            $this->orderRepository->persist($this->order);
        }
    }

    public function createOrderFromCart(): ?Order
    {
        $conn = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable('tx_igshop2_domain_model_cart');
        $stmt = $conn->prepare(
            'INSERT INTO tx_igshop2_domain_model_order (pid,userid,orderdate,total,customername,ordermail,orderinfo,paymentmode,payment_method,submitted,done,shipping_type,shipping_status,is_member,total_with_porto,plzort,strasse,paid,is_order,has_billing_address,checkout_reference,products,porto,country,country_text,currency,delivery_period,survey,cart,crdate,tstamp,shipping_service) 
            SELECT pid,userid,orderdate,total,customername,ordermail,orderinfo,paymentmode,payment_method,submitted,done,shipping_type,shipping_status,is_member,total_with_porto,plzort,strasse,paid,is_order,has_billing_address,checkout_reference,products,porto,country,country_text,currency,delivery_period,survey, ' . $this->cart->getUid() . ', ' . time() . ', ' . time() . ', shipping_service
            FROM tx_igshop2_domain_model_cart
            WHERE uid = ' . $this->cart->getUid() . ' AND deleted = 0 AND hidden = 0'
        );
        $stmt->executeStatement([]);
        $orderUid = $conn->lastInsertId();

        $stmt = $conn->prepare(
            'INSERT INTO tx_igshop2_domain_model_orderproduct (pid,unit_price,amount,price,prod_options,product,tx_order)
            SELECT pid,unit_price,amount,price,prod_options,product,' . $orderUid . '
            FROM tx_igshop2_domain_model_cartproduct
            WHERE tx_order = ' . $this->cart->getUid() . ' AND deleted = 0 AND hidden = 0'
        );
        $stmt->executeStatement([]);
        $this->order = $this->orderRepository->findByUid($orderUid);
        return $this->order;
    }
}
