<?php

namespace InternetGalerie\Igshop2\Utility;

use InternetGalerie\Igshop2\Domain\Model\AbstractOrder;
use InternetGalerie\Igshop2\Domain\Model\Product;
use Psr\Http\Message\ServerRequestInterface as Request;
use TYPO3\CMS\Core\Cache\CacheManager;
use TYPO3\CMS\Core\Cache\CacheTag;
use TYPO3\CMS\Core\SingletonInterface;
use TYPO3\CMS\Core\Utility\VersionNumberUtility;
use TYPO3\CMS\Frontend\Controller\TypoScriptFrontendController;

class ProductCacheUtility implements SingletonInterface
{
    public function __construct(
        private readonly CacheManager $cacheManager,
    ) {}

    public static function getProductTagName(Product $product): string
    {
        return 'tx_igshop2_product_' . $product->getUid();
    }
    
    public function flushByOrder(AbstractOrder $order): void
    {
        $tags = [];
        foreach ($order->getProducts() as $orderProduct) {
            $tags[] = static::getProductTagName($orderProduct->getProduct());
        }
        $this->cacheManager->flushCachesInGroupByTags('pages', $tags);
    }
    
    public function flushByProduct(Product $product): void
    {
        $tagName = static::getProductTagName($product);
        $this->cacheManager->flushCachesInGroupByTags('pages', [
            $tagName,
        ]);
    }

    public static function addTagByProduct(Request $request, ?Product $product): ?string
    {
        if ($product === null) {
            return null;
        }
        $tagName = static::getProductTagName($product);
        if (VersionNumberUtility::convertVersionNumberToInteger(VersionNumberUtility::getNumericTypo3Version()) >= 13030000) {
            $cacheDataCollector = $request->getAttribute('frontend.cache.collector');
            $cacheDataCollector->addCacheTags(
                new CacheTag($tagName)
            );
        } else {
            $frontendController = $request->getAttribute('frontend.controller');
            $frontendController->addCacheTags([$tagName]);
       }
        return $tagName;
    }

    
}