<?php

namespace InternetGalerie\Igshop2\Utility;

use InternetGalerie\Igshop2\Domain\Model\AbstractOrder;
use InternetGalerie\Igshop2\Domain\Model\Order;
use InternetGalerie\Igshop2\Domain\Model\Shipping;
use InternetGalerie\Igshop2\Domain\Model\ShippingService;
use InternetGalerie\Igshop2\Domain\Repository\ShippingRepository;

class ShippingUtility {
    public function __construct(protected ShippingRepository $shippingRepository)
    {
    }

    public function getShipping(?ShippingService $shippingService, array $search): ?Shipping
    {
        $shipping = null;
        if ($shippingService) {
            $shipping = $this->shippingRepository->findOneByShippingServiceAndSearch($shippingService, $search);
        }
        return $shipping;
    }

    public function getShippingAmount(Order $order): float
    {
        $shipping = $order->getShipping();
        $shippingAmount = 0.0;
        if($shipping) {
            $shippingAmount = $shipping->getPrice();
        }

        return $shippingAmount;
    }
}