<?php

namespace InternetGalerie\Igshop2\ViewHelpers;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractTagBasedViewHelper;
/**
 * This class is a demo view helper for the Fluid templating engine.
 *
 * @subpackage Fluid
 * @version
 */
class CategoryViewHelper extends AbstractTagBasedViewHelper
{
    /**
     * @var string
     */
    protected $tagName = 'a';
    
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerUniversalTagAttributes();
        $this->registerTagAttribute('target', 'string', 'Specifies where to open the linked document');
        
        $this->registerArgument('categories', 'array', 'Categories', true);
        $this->registerArgument('top', 'boolean', 'Top', false, true);
        $this->registerArgument('rootElement', 'int', 'Root Element', false, 0);
        $this->registerArgument('pageID', 'string', 'Page ID', false, '');
    }
    
    /**
     * Renders the Recursive Navigation from the Category-Tree
     */
    public function render(): string
    {
        $categories = $this->arguments['categories'];
        $top = $this->arguments['top'];
        $rootElement = $this->arguments['rootElement'];
        $pageID = $this->arguments['pageID'];
        
        foreach ($categories as $key => $value) {
            if ($top) {
                $this -> rekursiv .= '<ul>';
                $rootElement = $value['object']->getUid();
            }
            
            $this -> rekursiv .= '<li>' . $value['object']->getName();
            
            if (count($value['children']) > 0) {
                $this -> rekursiv .= '<ul>';
                $this->arguments['categories'] = $value['children'];
                $this->arguments['top'] = false;
                $this -> render();
                $this -> rekursiv .= '</ul>';
            }

            $this -> rekursiv .= '</li>';
            if ($top) {
                $this -> rekursiv .= '</ul>';
            }
        }
        
        return $this->rekursiv;
    }
}
