<?php

namespace InternetGalerie\Igshop2\ViewHelpers\Form;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractTagBasedViewHelper;
use TYPO3\CMS\Extbase\Service\ImageService;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;

class AddToCartViewHelper extends AbstractTagBasedViewHelper
{
    protected ImageService $imageService;

    /**
     * @var string
     */
    protected $tagName = 'a';

    public function injectImageService(ImageService $imageService): void
    {
        $this->imageService = $imageService;
    }

    /**
     * Initialize the arguments.
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('successText', 'string', 'Text after adding product to cart', false, '');
        $this->registerArgument('errorRequiredText', 'string', 'Text on error if not all required fields are filled', false, '');
        $this->registerArgument('openCart', 'boolean', 'Open small cart after adding product to cart', false, false);
        $this->registerArgument(
            'linkText',
            'string',
            'Link text',
            false,
            LocalizationUtility::translate('product.show.submitButton', 'igshop2')
        );
        $this->registerArgument(
            'ajaxLoader',
            'string',
            'Path to ajax loader gif',
            false,
            'EXT:igshop2/Resources/Public/Images/Order/ajax-loader-white.gif'
        );
        $this->registerUniversalTagAttributes();
    }

    /**
     * Renders the textfield.
     *
     * @return string
     */
    public function render()
    {
        if (!$this->tag->hasAttribute('href')) {
            $this->tag->addAttribute('href', '#');
        }

        $class = 'submit_product link-button';
        if ($this->tag->hasAttribute('class')) {
            $this->tag->addAttribute('class', $class . ' ' . $this->tag->getAttribute('class'));
            $this->arguments['class'] = $class . ' ' . $this->tag->getAttribute('class');
        } else {
            $this->tag->addAttribute('class', $class);
            $this->arguments['class'] = $class;
        }

        if ($this->arguments['successText']) {
            $this->tag->addAttribute('data-success-text', $this->arguments['successText']);
        }
        if ($this->arguments['errorRequiredText']) {
            $this->tag->addAttribute('data-error-required-text', $this->arguments['errorRequiredText']);
        }

        if ($this->arguments['openCart']) {
            $this->tag->addAttribute('data-open-cart', $this->arguments['openCart'] ? true : false);
        }

        $content = '';
        if ($this->arguments['linkText']) {
            $content .= '<span class="add-cart-text">' . $this->arguments['linkText'] . '</span>';
        }

        if ($this->arguments['ajaxLoader']) {
            $image = $this->imageService->getImage($this->arguments['ajaxLoader'], null, false);
            $ajaxLoader = $this->imageService->getImageUri($image, true);
            $content .= '<span class="ajax-loader" style="display: none;"><img src="' . $ajaxLoader . '" /></span>';
        }

        if ($content) {
            $this->tag->setContent($this->renderChildren() . $content);
        } else {
            $this->tag->setContent($this->renderChildren());
        }

        return parent::render();
    }
}
