<?php

namespace InternetGalerie\Igshop2\ViewHelpers;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use InternetGalerie\Igshop2\Domain\Repository\CurrencyRepository;
/**
 * This class is a demo view helper for the Fluid templating engine.
 *
 * @subpackage Fluid
 * @version
 */
class FormatProductPriceViewHelper extends AbstractViewHelper
{
    /**
     * currencyRepository
     *
     * @var CurrencyRepository
     */
    public $currencyRepository = null;


    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this -> registerArgument('product', 'mixed', 'Product', false);
        $this -> registerArgument('productOption', 'mixed', 'Product Option', false);
        $this -> registerArgument('notAvailableText', 'string', 'Text falls Produkt nicht verfuegbar', false, false);
    }

    /**
     * Rounds the price to CHF norm
     */
    public function render(): string
    {
        $content = '';

        $product = $this->arguments['product'];
        $notAvailableText = $this->arguments['notAvailableText'];
        $optionWithPrice = $this->arguments['productOption'];


        $currencies = $this->currencyRepository->findAllForPrices();
        foreach ($currencies as $currency) {
            if (is_object($optionWithPrice)) {
                $price = $optionWithPrice->getFinalPrice($currency);
                $p = $optionWithPrice;
            }

            if (is_object($product)) {
                $price = $product->getFinalPrice($currency, 0, 0, $checkForPromotion);
                $p = $product;
            }

            /*
            //var_dump($price);
            if(is_array($price)){
            $promotePrice = $this->format($currency, $price["price"]);
            $origPrice = $this->format($currency, $price["origPrice"]);
            return '<div class="origPrice">'.$origPrice.'</div><div class="promoPrice">'.$promotePrice.'</div>';
            }
            */
            if ($currency->getShort() == 'EUR' && $p->getPriceEuro() !== null && $p->getPriceEuro() <= 0) {
                $content .= '<div  class="currency-' . $currency->getShort() . '">' . $notAvailableText . '</div>';
            } else {
                $content .= '<div itemprop="offers" itemscope itemtype="http://schema.org/Offer" class="currency-' . $currency->getShort() . '">';
                $content_currency = '<span itemprop="priceCurrency" content="' . $currency->getShort() . '">' . $currency->getSymbol() . '</span>';
                $content_price = '<span itemprop="price" content="' . $this->round(
                    $currency,
                    $price
                ) . '">' . $this->format(
                    $currency,
                    $price
                ) . '</span>';
                if ($currency->getAfterPrice()) {
                    $content .= $content_price . ' ' . $content_currency;
                } else {
                    $content .= $content_currency . ' ' . $content_price;
                }

                $content .= '</div>';
            }
        }

        return $content;
    }

    public function injectCurrencyRepository(
        CurrencyRepository $currencyRepository
    ): void {
        $this->currencyRepository = $currencyRepository;
    }

    private function round($currency, $price): string
    {
        if ($currency->getRounding()) {
            $rounding = $currency->getRounding();
            return number_format(round($price * (1 / $rounding)) / (1 / $rounding), 2);
        }

        return number_format($price, 2);
    }

    private function format($currency, $price): string
    {
        if ($currency->getRounding()) {
            $thousandSeparator = $currency->getThousandSeparator();
            $commaSeparator = $currency->getCommaseparator();
            $rounding = $currency->getRounding();
            if ($thousandSeparator != null && $commaSeparator != null) {
                $return = number_format(
                    round($price * (1 / $rounding)) / (1 / $rounding),
                    2,
                    $commaSeparator,
                    $thousandSeparator
                );
            } else {
                $return = number_format(round($price * (1 / $rounding)) / (1 / $rounding), 2);
            }
        } else {
            $return = $price;
        }

        return $return;
    }
}
