<?php

namespace InternetGalerie\Igshop2\ViewHelpers;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use PDO;
use TYPO3\CMS\Core\Resource\FileRepository;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * This class is a demo view helper for the Fluid templating engine.
 *
 * @subpackage Fluid
 * @version
 */
class ImageViewHelper extends AbstractViewHelper
{
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('uid', 'int', 'UID of Image', true);
    }

    /**
     * Returns the URL from an image, selected by uid
     */
    public function render(): string
    {
        $uid = $this->arguments['uid'];

        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable(
            'sys_file_reference'
        );
        $row = $queryBuilder->select('uid_local')
->from('sys_file_reference')
->where(
    $queryBuilder->expr()
->eq('uid_foreign', $queryBuilder->createNamedParameter($uid, PDO::PARAM_INT))
)->executeQuery()
->fetchAssociative();
        //$row = $GLOBALS['TYPO3_DB']->exec_SELECTgetSingleRow("uid_local", "sys_file_reference", "uid=".$uid);
        $fileRepository = GeneralUtility::makeInstance(FileRepository::class);
        $storage = $fileRepository->findByUid($row['uid_local']);

        return $storage->getPublicUrl();
    }
}
