<?php

namespace InternetGalerie\Igshop2\ViewHelpers;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
class InArrayViewHelper extends AbstractViewHelper
{
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('haystack', 'mixed', 'View helper haystack ', true);
        $this->registerArgument('needle', 'string', 'View helper needle', true);
    }

    /**
     * Check if value is in array
     *
     * @return boolean
     * @api
     */
    public function render(): string
    {
        $needle = $this->arguments['needle'];
        $haystack = $this->arguments['haystack'];

        if (is_string($haystack)) {
            $haystack = strpos($haystack, ',') ? explode(',', $haystack) : $haystack;
            if (!is_array($haystack)) {
                return false;
            }
        }

        if (is_countable($haystack)) {
            if (count($haystack) == 0) {
                return false;
            }

            foreach ($haystack as $stack) {
                if (is_object($stack)) {
                    if ($needle === $stack->getProduct()) {
                        return $stack;
                    }
                } else {
                    if ($needle == $stack) {
                        return true;
                    }
                }
            }
        }

        return false;
    }
}
