<?php

namespace InternetGalerie\Igshop2\ViewHelpers\Link;

use Psr\Http\Message\ServerRequestInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
use TYPO3\CMS\Core\Page\PageRenderer;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3\CMS\Extbase\Mvc\ExtbaseRequestParameters;
use TYPO3\CMS\Extbase\Mvc\Request;
use TYPO3\CMS\Extbase\Mvc\Web\Routing\UriBuilder;
use TYPO3\CMS\Fluid\Core\Rendering\RenderingContext;

/*
                      <shop:link.smallCart>Warenkorb</shop:link.smallCart>
                      <shop:ajax.div action="cart">
                        <shop:ajax.field name="cart" class="dropdown_content header_popup_products" />
                      </shop:ajax.div>
                      <div class="shop_header">
                        <shop:link.cart><img src="/fileadmin/layout/images_layout/bag.svg" width="20" /></shop:link.cart> (<shop:ajax.field name="count">0</shop:ajax.field>
                      </div>
<shop:ajax.field name="totalCurrency">CHF 0</shop:ajax.field><shop:ajax.field name="currency" /><shop:ajax.field name="total" />
<shop:ajax.field name="productsCount" />
*/

class ReminderListViewHelper extends AbstractViewHelper
{
    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    /**
     * @var ConfigurationManagerInterface
     */
    protected $configurationManager;

    /**
     * @var UriBuilder
     */
    protected $uriBuilder;

    protected $settings = null;


    public function injectConfigurationManager(ConfigurationManagerInterface $configurationManager): void
    {
        $this->configurationManager = $configurationManager;
    }



    public function injectUriBuilder(UriBuilder $uriBuilder): void
    {
        $this->uriBuilder = $uriBuilder;
    }


    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        //$this->registerArgument('cartPageUid' 'int', 'Page Uid of Cart', true); // muss dies in Settings
        // $this->registerArgument('smallCartPageUid' 'int', 'Page Uid of Small Cart Ajax Page', true); // muss dies in Settings
    }

    /**
     * Render Area Width
     *
     * @return string Widrth of current Area
     */
    public function render(): string
    {
        $pageRenderer = GeneralUtility::makeInstance(PageRenderer::class);
        $pageRenderer->addJsFooterFile('EXT:igshop2/Resources/Public/JavaScript/ReminderList/reminderList.js');

        $this->settings = $this->configurationManager->getConfiguration(
            ConfigurationManagerInterface::CONFIGURATION_TYPE_SETTINGS,
            'Igshop2',
            ''
        );

        /** @var RenderingContext $renderingContext */
        $request = null;
        if (method_exists($this->renderingContext, 'getRequest')) {
            // TYPO3 v12 compatibility
            $request = $this->renderingContext->getRequest();
        } elseif ($this->renderingContext->hasAttribute(ServerRequestInterface::class)) {
            // TYPO3 v13+ compatibility
            $request = $this->renderingContext->getAttribute(ServerRequestInterface::class);
        }
        $extbaseRequest = new Request($request->withAttribute('extbase', new ExtbaseRequestParameters()));
        $reminderListPid = intval($this->settings['reminderList']['pageUid'] ?? 0);

        $uriBuilder = GeneralUtility::makeInstance(UriBuilder::class);
        $fetchProductsUrl = $uriBuilder
            ->reset()
            ->setRequest($extbaseRequest)
            ->setTargetPageUid($reminderListPid)
            ->setNoCache(1)
            ->setTargetPageType(3000)
            ->uriFor('fetchProducts', [], 'ReminderList', 'Igshop2', 'ReminderList');

        $reminderListUrl = $uriBuilder
            ->reset()
            ->setRequest($extbaseRequest)
            ->setTargetPageUid($reminderListPid)
            ->build();

        $output = $this->renderChildren();
        return '<div class="igshop-container tx-igshop2-reminder-list-small igshop-ajax-action-' . $this->arguments['action'] . '" data-fetch-products-url="' . htmlspecialchars(
            $fetchProductsUrl
        ) . '"><a href="' . $reminderListUrl . '">' . $output . '</a></div>';
    }
}
