<?php

namespace InternetGalerie\Igshop2\ViewHelpers\Mandant;

use Closure;
use InternetGalerie\Igshop2\Domain\Repository\CategoryRepository;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class CategoriesViewHelper extends AbstractViewHelper
{
    /**
     * As this ViewHelper renders HTML, the output must not be escaped.
     *
     * @var bool
     */
    protected $escapeOutput = false;

    /**
     * Initialize arguments.
     */
    public function initializeArguments(): void
    {
        $this->registerArgument('uid', 'int', 'organisation uid', true);
        //$this->registerArgument('pid', 'int', 'organisation uid', true);
        $this->registerArgument('as', 'string', 'name for organisation object ', true);
    }

    /**
     * @return bool
     */
    public static function renderStatic(
        array $arguments,
        Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ): string {
        $categoryRepository = GeneralUtility::makeInstance(CategoryRepository::class);
        $mandantUid = $arguments['uid'];
        $categories = $categoryRepository->findAllWithProducts($mandantUid);
        $templateVariableContainer = $renderingContext->getVariableProvider();
        $templateVariableContainer->add($arguments['as'], $categories);

        $output = $renderChildrenClosure();
        $templateVariableContainer->remove($arguments['as']);
        return $output;
    }
}
