<?php

namespace InternetGalerie\Igshop2\ViewHelpers;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;
/**
 * This class is a demo view helper for the Fluid templating engine.
 *
 * @subpackage Fluid
 * @version
 */
class PriceLabelIsMeasurementViewHelper extends AbstractViewHelper
{
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        
        $this->registerArgument('priceLabel', 'string', 'Price label', true);
    }

    /**
     * Returns the $key Key element from an array
     *
     * @return boolean
     */
    public function render(): string
    {
        $priceLabel = $this->arguments['priceLabel'];
        return preg_match('/(^[0-9]+\s)\w+/', (string) $priceLabel) != false;
    }
}
