<?php

namespace InternetGalerie\Igshop2\ViewHelpers;

use InternetGalerie\Igshop2\Domain\Model\Product;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class StockViewHelper extends AbstractViewHelper
{
    protected $escapeOutput = false;

    public function initializeArguments(): void
    {
        $this->registerArgument('product', Product::class, 'Product', true);
        $this->registerArgument('lowStockLimit', 'int', 'ouput item-low-stock class if stock is below this limit', false, null);
        $this->registerArgument('classOutOfStock', 'string', 'css class when item is out of stock', false, 'item-out-of-stock');
        $this->registerArgument('classInStock', 'string', 'css class when item is in stock', false, 'item-in-stock');
        $this->registerArgument('classLowStock', 'string', 'css class when item is low in stock (below or equal lowStockLimit)', false, 'item-low-stock');
    }
    public static function renderStatic(
        array $arguments,
        \Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    )
    {
        $classes = [];
        $product = $arguments['product'];
        $lowStockLimit = $arguments['lowStockLimit'];

        if ($product->getStock() === null) {
            return '';
        }
        if ($product->getStock() <= 0) {
            $translationKey = $product->allowsBackorder() ? 'out-of-stock-with-backorder' : 'out-of-stock';
            $classes[] = $arguments['classOutOfStock'];
        } else {
            // Plural
            $translationKey = $product->getStock() === 1 ? 'piece-in-stock' : 'pieces-in-stock';
            $classes[] = $arguments['classInStock'];
        }
        if ($lowStockLimit !== null && $product->getStock() <= $lowStockLimit) {
             $classes[] = $arguments['classLowStock'];
        }
        $text = LocalizationUtility::translate(
            $translationKey,
            'igshop2',
            [$product->getStock()]
        );
        return '<span class="' . implode(' ', $classes) . '">' . htmlspecialchars($text) . '</span>';
    }

}