<?php

namespace InternetGalerie\Igshop2\ViewHelpers\Uri;

use Closure;
use InternetGalerie\Igshop2\Domain\Model\Product;
use Psr\Http\Message\ServerRequestInterface;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Utility\HttpUtility;
use TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer;
use TYPO3\CMS\Frontend\Typolink\LinkFactory;
use TYPO3\CMS\Frontend\Typolink\UnableToLinkException;
use TYPO3Fluid\Fluid\Core\Rendering\RenderingContextInterface;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class ProductViewHelper extends AbstractViewHelper
{
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('product', Product::class, 'Product', true);
        $this->registerArgument('pageUid', 'int', 'pageUid for show page', false);
        $this->registerArgument(
            'fallbackPageUid',
            'int',
            'fallback pageUid for show page, if not defined in categories',
            false
        );
        $this->registerArgument('absolute', 'bool', 'If set, the URI of the rendered link is absolute');
    }

    public static function renderStatic(
        array $arguments,
        Closure $renderChildrenClosure,
        RenderingContextInterface $renderingContext
    ): string {
        $request = null;
        if (method_exists($this->renderingContext, 'getRequest')) {
            // TYPO3 v12 compatibility
            $request = $this->renderingContext->getRequest();
        } elseif ($this->renderingContext->hasAttribute(ServerRequestInterface::class)) {
            // TYPO3 v13+ compatibility
            $request = $this->renderingContext->getAttribute(ServerRequestInterface::class);
        }
        $pageUid = (int)($arguments['pageUid'] ?? 0);
        $fallbackPageUid = (int)($arguments['fallbackPageUid'] ?? 0);
        $product = $arguments['product'];
        $absolute = (bool)($arguments['absolute'] ?? false);

        if ($pageUid > 0) {
            $targetPageUid = $pageUid;
        } else {
            $targetPageUid = $product->getDetailPageUid();
            if ($targetPageUid === null || $targetPageUid == 0) {
                $targetPageUid = $product->getCategoryDetailPageUid();
                if ($targetPageUid === null || $targetPageUid == 0) {
                    $targetPageUid = $fallbackPageUid;
                }
            }
        }
        
        $typolinkConfiguration = [
            'parameter' => $targetPageUid,
        ];
        $extensionName = 'IgShop2'; //$request->getControllerExtensionName();
        $pluginName = 'FeshopShow';
        $controller = 'Product';
        $action = 'show';
        $arguments = [
            'product' => $product->getUid(),
        ];
        $extbaseArgumentNamespace = 'tx_'
            . str_replace('_', '', strtolower($extensionName))
            . '_'
            . str_replace('_', '', strtolower($pluginName));
        $additionalParams = [];
        $additionalParams[$extbaseArgumentNamespace] = array_replace(
            [
                'controller' => $controller,
                'action' => $action,
            ],
            $arguments
        );
        $typolinkConfiguration['additionalParams'] = HttpUtility::buildQueryString($additionalParams, '&');
        if ($absolute) {
            $typolinkConfiguration['forceAbsoluteUrl'] = true;
        }


        try {
            $cObj = GeneralUtility::makeInstance(ContentObjectRenderer::class);
            $cObj->setRequest($request);
            $linkFactory = GeneralUtility::makeInstance(LinkFactory::class);
            $linkResult = $linkFactory->create((string)$renderChildrenClosure(), $typolinkConfiguration, $cObj);
            return $linkResult->getUrl();
        } catch (UnableToLinkException) {
            return (string)$renderChildrenClosure();
        }
    }
}
