<?php

declare(strict_types=1);

namespace InternetGalerie\Igshop2\Widgets\Provider;

use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class ProductCategoryProvider implements ProductProviderInterface
{
    /**
     * @var int
     */
    private $limit;

    public function __construct(int $limit)
    {
        $this->limit = $limit ?: 10;
    }


    public function getProductTotal(): array
    {
        $conn = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable(
            'tx_igshop2_domain_model_product'
        );
        $stmt = $conn->prepare('SELECT count(1) AS total FROM tx_igshop2_domain_model_product');
        $res = $stmt->executeQuery([]);
        $row = $res->fetchAssociative();

        return [
            'title' => 'Total',
            'count' => $row['total'],
        ];
    }

    public function getCategories(): array
    {
        $items = [];
        //$queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_igshop2_domain_model_product');
        $conn = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable(
            'tx_igshop2_domain_model_product'
        );
        $sql = 'SELECT tx_igshop2_domain_model_category.uid,tx_igshop2_domain_model_category.name,SUM(1) AS productCount FROM tx_igshop2_domain_model_product JOIN tx_igshop2_product_category_mm ON tx_igshop2_domain_model_product.uid=uid_local JOIN tx_igshop2_domain_model_category ON uid_foreign=tx_igshop2_domain_model_category.uid WHERE tx_igshop2_domain_model_category.deleted=0 AND tx_igshop2_domain_model_product.deleted=0 AND tx_igshop2_domain_model_product.hidden=0 AND  tx_igshop2_domain_model_category.hidden=0 GROUP BY tx_igshop2_domain_model_category.name,tx_igshop2_domain_model_category.uid ORDER BY SUM(1) DESC LIMIT ' . (int) $this->limit;
        $stmt = $conn->prepare($sql);
        $res = $stmt->executeQuery([]);
        while ($row = $res->fetchAssociative()) {
            $items[] = [
                'uid' => $row['uid'],
                'title' => $row['name'],
                'count' => $row['productCount'],
            ];
        }

        return $items;
    }

    public function getLimit(): int
    {
        return $this->limit;
    }
}
