<?php

use InternetGalerie\Igshop2\Controller\BackendProductController;
use InternetGalerie\Igshop2\Controller\BackendCategoryController;
use InternetGalerie\Igshop2\Controller\BackendPropertyController;
use InternetGalerie\Igshop2\Controller\BackendPropertycategoryController;
use TYPO3\CMS\Core\Information\Typo3Version;
use TYPO3\CMS\Core\Utility\GeneralUtility;

$typo3Version = GeneralUtility::makeInstance(Typo3Version::class);
$navigationComponent = $typo3Version->getMajorVersion() > 12 ? '@internetgalerie/igshop2/tree/category-tree-element' : '@internetgalerie/igshop2/category-tree/category-tree-element';
$navigationComponentPropertycategory = $typo3Version->getMajorVersion() > 12 ? '@internetgalerie/igshop2/propertycategory-tree/category-tree-element' : '@internetgalerie/igshop2/propertycategory-category-tree/category-tree-element';

return [
    'igshop2_main' => [
        'extensionName' => 'Igshop2',
        'position' => ['after' => 'file'],
        'access' => 'user',
        'icon' => 'EXT:igshop2/Resources/Public/Icons/module-shop.svg',
        'labels' => 'LLL:EXT:igshop2/Resources/Private/Language/locallangNavShop.xlf',
    ],
    'igshop2_products' => [
        'parent' => 'igshop2_main',
        'extensionName' => 'Igshop2',
        'position' => ['top'],
        'access' => 'user',
        'icon' => 'EXT:igshop2/Resources/Public/Icons/module-shop-products.svg',
        'labels' => 'LLL:EXT:igshop2/Resources/Private/Language/locallangNavProduct.xlf',
        'path' => '/igshop2/products',
        'navigationComponent' => $navigationComponent,
        'controllerActions' => [
            BackendProductController::class => ['index', 'sortProductsInCategory'],
            BackendCategoryController::class => ['index'],
        ]
    ],
    'igshop2_categories' => [
        'parent' => 'igshop2_main',
        'extensionName' => 'Igshop2',
        'position' => ['top'],
        'access' => 'user',
        'icon' => 'EXT:igshop2/Resources/Public/Icons/module-shop-categories.svg',
        'labels' => 'LLL:EXT:igshop2/Resources/Private/Language/locallangNavCategory.xlf',
        'path' => '/igshop2/categories',
        'navigationComponent' => $navigationComponent,
        'controllerActions' => [
            BackendCategoryController::class => ['index'],
            BackendProductController::class => ['index', 'sortProductsInCategory'],
        ]
    ],
    'igshop2_properties' => [
        'parent' => 'igshop2_main',
        'extensionName' => 'Igshop2',
        'position' => ['top'],
        'access' => 'user',
        'icon' => 'EXT:igshop2/Resources/Public/Icons/module-shop-properties.svg',
        'labels' => 'LLL:EXT:igshop2/Resources/Private/Language/locallangNavProperty.xlf',
        'path' => '/igshop2/properties',
        'navigationComponent' => $navigationComponentPropertycategory,
        'controllerActions' => [
            BackendPropertyController::class => ['index', 'sortProductsInCategory'],
            BackendPropertycategoryController::class => ['index'],
        ]
    ],
    'igshop2_propertycategories' => [
        'parent' => 'igshop2_main',
        'extensionName' => 'Igshop2',
        'position' => ['top'],
        'access' => 'user',
        'icon' => 'EXT:igshop2/Resources/Public/Icons/module-shop-propertycategories.svg',
        'labels' => 'LLL:EXT:igshop2/Resources/Private/Language/locallangNavPropertycategory.xlf',
        'path' => '/igshop2/propertycategories',
        'navigationComponent' => $navigationComponentPropertycategory,
        'controllerActions' => [
            BackendPropertycategoryController::class => ['index'],
            BackendPropertyController::class => ['index', 'sortProductsInCategory'],
        ]
    ],
];
