<?php
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Information\Typo3Version;
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
if (!defined ('TYPO3')) {
	die ('Access denied.');
}

$versionInformation = GeneralUtility::makeInstance(Typo3Version::class);
if ($versionInformation->getMajorVersion() > 11) {
    $imagesConfig = [
        'type' => 'file',
        'foreign_match_fields' => [
            'tablenames' => 'tx_igshop2_domain_model_category',
        ],
        'maxitems' => 9999,
        'allowed' => 'common-image-types',
    ];
} else {
    $imagesConfig = ExtensionManagementUtility::getFileFieldTCAConfig(
        'image',
        [
            'appearance' => [
                'createNewRelationLinkTitle' => 'LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:images.addFileReference'
            ],
            'foreign_match_fields' => [
                'tablenames' => 'tx_igshop2_domain_model_category',
            ],
            // Alle Zeilen von V11 (foreign_types...)
            'maxitems' => 9999,
        ],
        $GLOBALS['TYPO3_CONF_VARS']['GFX']['imagefile_ext']
    );
}

$GLOBALS['TCA']['tx_igshop2_domain_model_category'] = [
	'ctrl' => [
        'title' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_category',
        'label' => 'name',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'cruser_id' => 'cruser_id',

        'versioningWS' => 2,
        'versioning_followPages' => TRUE,

        'languageField' => 'sys_language_uid',
        'sortby' => 'sorting',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'name,teaser,description,external_id,active,parent,view',
        'iconfile' => 'EXT:igshop2/Resources/Public/Icons/tx_igshop2_domain_model_category.svg'
    ],
	'types' => [
		'1' => ['showitem' => 'sys_language_uid,--palette--,l10n_parent,l10n_diffsource,hidden,--palette--;;1,view,parent,name,teaser,description,path_segment,external_id,hide_in_navigation,hide_in_export,exclude_slug,without_porto,image,list_page_uid,detail_page_uid,products,--div--;Eigenschaften,properties,--div--;LLL:EXT:frontend/Resources/Private/Language/locallang_ttc.xlf:tabs.access,starttime,endtime'],
	],
	'palettes' => [
		'1' => ['showitem' => ''],
	],
	'columns' => [

		'sys_language_uid' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
			'config' => ['type' => 'language'],
		],
		'l10n_parent' => [
			'displayCond' => 'FIELD:sys_language_uid:>:0',
			'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
			'config' => [
				'type' => 'select',
                'renderType' => 'selectSingle',
				'items' => [
					['label' => '', 'value' => 0],
				],
				'foreign_table' => 'tx_igshop2_domain_model_category',
				'foreign_table_where' => 'AND tx_igshop2_domain_model_category.pid=###CURRENT_PID### AND tx_igshop2_domain_model_category.sys_language_uid IN (-1,0)',
			],
		],
		'l10n_diffsource' => [
			'config' => [
				'type' => 'passthrough',
			],
		],

		't3ver_label' => [
			'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.versionLabel',
			'config' => [
				'type' => 'input',
				'size' => 30,
				'max' => 255,
			]
		],
		'sorting' => [
			'exclude' => 1,
			'l10n_mode' => 'exclude',
			'config' => [
                'type' => 'passthrough'
			]
		],

		'hidden' => [
			'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.visible',
			'config' => [
				'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        'invertStateDisplay' => true
                    ]
                ],
			],
		],
		
        'starttime' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
            ],
            'l10n_mode' => 'exclude',
            'l10n_display' => 'defaultAsReadonly',
        ],
        'endtime' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'datetime',
                'default' => 0,
                'range' => [
                    'upper' => mktime(0, 0, 0, 1, 1, 2038),
                ],
            ],
            'l10n_mode' => 'exclude',
            'l10n_display' => 'defaultAsReadonly',
        ],

		'name' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_category.name',
			'config' => [
				'type' => 'input',
				'size' => 30,
				'eval' => 'trim'
			],
		],

        'external_id' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_category.external_id',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim'
            ],
        ],
		'active' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_category.active',
			'config' => [
				'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        1 => ''
                    ]
                ],
				'default' => 0
			]
		],
		'hide_in_navigation' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_category.hide_in_navigation',
			'config' => [
				'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        1 => ''
                    ]
                ],
				'default' => 0
			]
		],
		'hide_in_export' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_category.hide_in_export',
			'config' => [
				'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        1 => ''
                    ]
                ],
				'default' => 0
			]
		],
		'exclude_slug' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_category.exclude_slug',
			'config' => [
				'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        1 => ''
                    ]
                ],
				'default' => 0
			]
		],
		'without_porto' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_category.without_porto',
			'config' => [
				'type' => 'check',
                'renderType' => 'checkboxToggle',
                'items' => [
                    [
                        'label' => '',
                        1 => ''
                    ]
                ],
				'default' => 0
			]
		],
		'parent' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_category.parent',
			'config' => [
				'type' => 'select',
                'renderType' => 'selectSingle',
                'items' => [
                    ['label' => 'Hauptkategorie (Root)', 'value' => 0],
                ],
				'foreign_table' => 'tx_igshop2_domain_model_category',
				'foreign_table_where' => 'AND tx_igshop2_domain_model_category.pid=###CURRENT_PID### ORDER BY name ASC',
				'minitems' => 0,
				'maxitems' => 1,
			],
		],

        /*
          'products' => array(
          'exclude' => 1,
          'l10n_mode' => '',
          'displayCond' => 'FIELD:sys_language_uid:<=:0',
          'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_order.products',
          'config' => array(
          'type' => 'inline',
          'foreign_table' => 'tx_igshop2_domain_model_product',
          //'foreign_table_where' => 'AND tx_igshop2_domain_model_product.pid=###CURRENT_PID### AND tx_igshop2_domain_model_product.sys_language_uid IN (-1,0)',
          //'foreign_field' => 'uid_foreign',
          'foreign_sortby' => 'sorting_foreign',
          //'foreign_table_field' => 'tablenames',
          //'foreign_match_fields' => [
          //    'fieldname' => 'category',
          //],
          //'foreign_selector' => 'uid_local',
          //'foreign_label' => 'uid_local',
          'MM' => 'tx_igshop2_product_category_mm',
          'MM_opposite_field' => 'category',
          'maxitems'      => 9999,
          'appearance' => array(
          'collapseAll' => 1,
          'levelLinksPosition' => 'top',
          'showPossibleLocalizationRecords' => 0,
          'showRemovedLocalizationRecords' => 0,
          'showSynchronizationLink' => 1,
          'showAllLocalizationLink' => 1,
          'useSortable' => 1
          ),
          //'behaviour' => [
          //    'localizationMode' => 'select',
          //    'localizeChildrenAtParentLocalization' => true
          //]
          ),
          ),
        */
        'description' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_category.description',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
                'enableRichtext' => true,
            ],
            //'defaultExtras' => 'richtext[*]:rte_transform[mode=ts_links]'
        ],
        'teaser' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.product_info',
            'config' => [
                'type' => 'text',
                'cols' => 40,
                'rows' => 15,
                'eval' => 'trim',
                'enableRichtext' => true,
            ],
            //'defaultExtras' => 'richtext[*]:rte_transform[mode=ts_links]'
        ],
        'path_segment' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.path_segment',
            'config' => [
                'type' => 'slug',
                'size' => 50,
                'eval' => 'uniqueInSite',
                'fallbackCharacter' => '-',
                'default' => '',
                'generatorOptions' => [
                    'fields' => ['name'],
                    'fieldSeparator' => '-',
                    'prefixParentPageSlug' => false,
                    'replacements' => [
                        '/' => 'und',
                    ],
                ],
            ]
        ],
        'view' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_category.view',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectSingle',
                'foreign_table' => 'tx_igshop2_domain_model_categoryview',
                'minitems' => 0,
                'maxitems' => 1,
                'items' => [
                    ['label' => '', 'value' => 0],
                ],
            ],
        ],
        'detail_page_uid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_category.detail_page_uid',
            'config' => [
                'type' => 'group',
                'allowed' => 'pages',
                'maxitems' => 1,
            ],
        ],
        'list_page_uid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_category.list_page_uid',
            'config' => [
                'type' => 'group',
                'allowed' => 'pages',
                'maxitems' => 1,
            ],
        ],
		'image' => [
			'exclude' => 1,
			'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.image',
			'config' => $imagesConfig,

		],
        'properties' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:igshop2/Resources/Private/Language/locallang_db.xlf:tx_igshop2_domain_model_product.properties',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectMultipleSideBySide',
                'foreign_table' => 'tx_igshop2_domain_model_property',
                'MM' => 'tx_igshop2_category_property_mm',
                'size' => 10,
                'autoSizeMax' => 30,
                'maxitems' => 9999,
                'multiple' => 0,
                'fieldControl' => [
                    'editPopup' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'Eigenschaft bearbeiten',
                        ],
                    ],
                    'addRecord' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'Eigenschaft hinzufügen',
                            'setValue' => 'prepend',
                        ],
                    ],
                    'listModule' => [
                        'disabled' => false,
                        'options' => [
                            'title' => 'vorhandene Eigenschaften',
                        ],
                    ],
                ],
            ],
        ],
	],
];
