document.addEventListener('DOMContentLoaded', function() {
	document.querySelector('select.igShop2_cart_currency')?.addEventListener('change', function() {
        this.closest('form').submit();
    });

	// Select all elements matching the selectors
    [...document.querySelectorAll("form[name=adress] a.cartContinue, .tx-igshop2 form .backlink a.cartContinue")].map(function(element) {
        // Add click event listener to each element
        element.addEventListener("click", function(event) {
            event.preventDefault(); // Prevent default action
            
            // Find the closest form element and submit it
            var form = element.closest("form");
            if (form) {
                form.submit();
            }
            
            return false; // Prevent further propagation
        });
    });

    if (typeof igshop2_billingAddressIsMain !== 'undefined' && !igshop2_billingAddressIsMain) {
        if (document.querySelector(".calcAddressForm")?.style.display === "block") {
            document.querySelector(".fade_down_button")?.classList.toggle("fade_up_button");
        }
    } else {
        if (document.querySelector(".addressForm")?.style.display === "block") {
            document.querySelector(".fade_down_button")?.classList.toggle("fade_up_button");
        }
    }

    [...document.querySelectorAll('.form_fadeDown')].map(function(element) {
        element.addEventListener('click', function() {
            // Toggle this class for up/down arrow
            document.querySelector('.fade_down_button').classList.toggle('fade_up_button');

            if (typeof igshop2_billingAddressIsMain === 'undefined') {
                // toggle the slide effect
                document.querySelector('.calcAddressForm').classList.toggle('show');

                // set value if calcAddress is set - needed for validation
                var iscalcAddress = document.getElementById('iscalcAddress');
                if (iscalcAddress.value == 1) {
                    iscalcAddress.value = 0;
                } else {
                    iscalcAddress.value = 1;
                }
            } else {
                // set value if calcAddress is set - needed for validation
                if (!document.querySelector('.fade_down_button').classList.contains('fade_up_button')) {
                    // toggle the slide effect
                    if (typeof igshop2_billingAddressIsMain !== 'undefined' && !igshop2_billingAddressIsMain) {
                        document.querySelector('.addressForm').classList.toggle('show');

                        document.getElementById('iscalcAddress').value = 1;
                        document.getElementById('isdeliveryAddress').value = 0;

                        if (document.getElementById('calcAddressSelect')) {
                            document.getElementById('extraBillingAddress').value = 0;
                            document.getElementById('calcAddressSelect').value = '';
                            document.querySelector('.igshop-calcAddressChoices .hiddenAddressField.clear').value = '';
                            document.querySelectorAll('.igshop-calcAddressChoices .igshop-addressChoice').forEach(function(choice) {
                                choice.classList.remove('active');
                            });
                        }
                    } else {
                        document.querySelector('.calcAddressForm').classList.toggle('show');

                        document.getElementById('isdeliveryAddress').value = 1;
                        document.getElementById('iscalcAddress').value = 0;

                        if (document.getElementById('addressSelect')) {
                            document.getElementById('extraDeliveryAddress').value = 0;
                            document.getElementById('addressSelect').value = '';
                            document.querySelector('.igshop-addressChoices .hiddenAddressField.clear').value = '';
                            document.querySelectorAll('.igshop-addressChoices .igshop-addressChoice').forEach(function(choice) {
                                choice.classList.remove('active');
                            });
                        }
                    }
                } else {
                    if (typeof igshop2_billingAddressIsMain !== 'undefined' && !igshop2_billingAddressIsMain) {
                        document.getElementById('iscalcAddress').value = 0;
                        document.getElementById('isdeliveryAddress').value = 1;

                        var activeChoice = document.querySelector('.igshop-calcAddressChoices .igshop-addressChoice.active');
                        if (!activeChoice) {
                            var firstChoice = document.querySelector('.igshop-calcAddressChoices .igshop-addressChoice');
                            firstChoice.classList.add('show');
                            firstChoice.querySelector('.addressChooseLink').click();
                        } else {
                            activeChoice.classList.add('show');
                            activeChoice.querySelector('.addressChooseLink').click();
                        }

                        if (document.getElementById('calcAddressSelect')) {
                            document.getElementById('extraBillingAddress').value = 1;
                        }

                        // toggle the slide effect
                        document.querySelector('.addressForm').classList.toggle('show');
                    } else {
                        document.getElementById('iscalcAddress').value = 1;
                        document.getElementById('isdeliveryAddress').value = 0;

                        var activeChoice = document.querySelector('.igshop-addressChoices .igshop-addressChoice.active');
                        if (!activeChoice) {
                            var firstChoice = document.querySelector('.igshop-addressChoices .igshop-addressChoice');
                            firstChoice.classList.add('show');
                            firstChoice.querySelector('.addressChooseLink').click();
                        } else {
                            activeChoice.classList.add('show');
                            activeChoice.querySelector('.addressChooseLink').click();
                        }

                        if (document.getElementById('addressSelect')) {
                            document.getElementById('extraDeliveryAddress').value = 1;
                        }

                        // toggle the slide effect
                        document.querySelector('.calcAddressForm').classList.toggle('show');
                    }
                }
            }
        });
    });

	[...document.querySelectorAll('.igshop-addressChoice .addressChooseLink')].map(function(element) {
        element.addEventListener('click', function(e) {
            e.preventDefault();
            
            var addressChoice = this.closest('.igshop-addressChoice');
            
            if (addressChoice.classList.contains('show')) {
                var parent = addressChoice.parentNode;
                var allAddressChoices = parent.querySelectorAll('.igshop-addressChoice');
                var address = JSON.parse(addressChoice.getAttribute('data-address'));

                [...allAddressChoices].map(function(choice) {
                    choice.classList.remove('active', 'show');
                });

                addressChoice.classList.add('active');

                parent.querySelector('.hiddenAddressField.clear').value = '';
                parent.querySelector('.addressSalutation').value = address.gender;
                parent.querySelector('.addressFirstName').value = address.firstName;
                parent.querySelector('.addressLastName').value = address.lastName;
                parent.querySelector('.addressCompany').value = address.company;
                parent.querySelector('.addressAddress').value = address.address;
                parent.querySelector('.addressZip').value = address.zip;
                parent.querySelector('.addressCity').value = address.city;
                parent.querySelector('.addressCountry').value = address.country;
                parent.querySelector('.addressUid').value = address.uid;
                parent.querySelector('.addressEmail').value = address.email;
                parent.querySelector('.addressPhone').value = address.phone;
                parent.querySelector('.addressSelect').value = address.uid;
                parent.querySelector('.addressIsPrivate').value = address.isPrivatePerson ? 1 : 0;

                parent.insertBefore(addressChoice, allAddressChoices[0]);

                if (typeof igshop2_billingAddressIsMain !== 'undefined' && !igshop2_billingAddressIsMain) {
                    var extraBillingAddress = parent.querySelector('#extraBillingAddress');
                    if (extraBillingAddress) {
                        extraBillingAddress.value = 1;
                    }
                } else {
                    var extraDeliveryAddress = parent.querySelector('#extraDeliveryAddress');
                    if (extraDeliveryAddress) {
                        extraDeliveryAddress.value = 1;
                    }
                }
            }
        });
    });

    // Check if there is an active address choice
    var activeAddressChoice = document.querySelector('.igshop-addressChoices .igshop-addressChoice.active');
    if (activeAddressChoice) {
        // Move the active address choice to the beginning
        var addressChoices = document.querySelector('.igshop-addressChoices');
        addressChoices.insertBefore(activeAddressChoice, addressChoices.firstElementChild);

        // Add 'show' class to the active address choice
        activeAddressChoice.classList.add('show');

        // Simulate a click on the '.addressChooseLink' element within the active address choice
        var addressChooseLink = activeAddressChoice.querySelector('.addressChooseLink');
        if (addressChooseLink) {
            addressChooseLink.click();
        }

        // Check additional conditions
        if (typeof igshop2_billingAddressIsMain !== 'undefined' && igshop2_billingAddressIsMain) {
            var isDeliveryAddress = document.querySelector('#isdeliveryAddress');
            if (isDeliveryAddress && isDeliveryAddress.value == '0') {
                document.querySelector('#extraDeliveryAddress').value = '0';
                document.querySelector('#addressSelect').value = '0';
                var hiddenAddressFields = document.querySelectorAll('.igshop-addressChoices .hiddenAddressField.clear');
                [...hiddenAddressFields].map(function(field) {
                    field.value = '';
                });
            }
        }
    }
    
    var calcAddressChoices = document.querySelectorAll('.igshop-calcAddressChoices .igshop-addressChoice');
    if (calcAddressChoices.length > 0) {
        var activeElement = document.querySelector('.igshop-calcAddressChoices .igshop-addressChoice.active');
        
        if (activeElement) {
            // Move active element to the beginning
            var firstElement = document.querySelector('.igshop-calcAddressChoices .igshop-addressChoice');
            firstElement.parentNode.insertBefore(activeElement, firstElement);

            // Add 'show' class to active element
            activeElement.classList.add('show');

            // Trigger click on .addressChooseLink inside active element
            var addressChooseLink = activeElement.querySelector('.addressChooseLink');
            if (addressChooseLink) {
                addressChooseLink.click();
            }

            // Additional conditions
            if (typeof igshop2_billingAddressIsMain !== 'undefined' && !igshop2_billingAddressIsMain) {
                var iscalcAddress = document.querySelector('#iscalcAddress').value;
                if (iscalcAddress == 0) {
                    document.querySelector('#extraBillingAddress').value = 0;
                    document.querySelector('#calcAddressSelect').value = 0;
                    var hiddenAddressField = document.querySelector('.igshop-calcAddressChoices .hiddenAddressField.clear');
                    if (hiddenAddressField) {
                        hiddenAddressField.value = '';
                    }
                }
            }
        }
    }

    [...document.querySelectorAll('.igshop-addressChoice .addressListLink')].map(function(link) {
        link.addEventListener('click', function(e) {
            e.preventDefault();
            var addressChoice = this.closest('.igshop-addressChoice');

            if (addressChoice.classList.contains('active')) {
                var parent = addressChoice.parentElement;
                Array.from(parent.children).forEach(function(child) {
                    if (!child.classList.contains('active')) {
                        child.classList.toggle('show');
                    }
                });
            }
        });
    });

    [...document.querySelectorAll('.addOrderProduct a.buyAgainSubmit')].map(function(element) {
        element.addEventListener('click', function(event) {
            event.preventDefault();

            var form = this.parentElement;
            var form_id = form.getAttribute('id');
            var orderProductId = form_id.split('_')[1];

            var url = this.dataset['page-2000'];

            var requestBody = new URLSearchParams({
                'tx_igshop2_fecart[action]': 'addOrderProduct',
                'tx_igshop2_fecart[controller]': 'Order',
                'tx_igshop2_fecart[orderProduct]': orderProductId,
                'type': '2000',
                'noCache': '1'
            });

            fetch(url, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                body: requestBody
            })
            .then(function(response) {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                return response.text();
            })
            .then(function(data) {
                if (typeof igShopSmallCarts !== 'undefined') {
                    igShopSmallCarts.forEach(function(smallCart) {
                        smallCart.update(function() {
                            smallCart.open();
                        });
                    });
                } else {
                    if(typeof igShopAjaxCounts !== 'undefined') {
                        igShopAjaxCounts.forEach(function(ajaxCount) {
                            ajaxCount.update();
                        });
                    }
                }
            })
            .catch(function(error) {
                console.error('There has been a problem with your fetch operation:', error);
            });
        });
    });

    [...document.querySelectorAll('.deleteProductLink')].map(function(link) {
        link.addEventListener('click', function(e) {
            e.preventDefault();
            var product = this.dataset.product;
            var toggleclass = this.dataset.toggleclass;
            
            document.querySelector('.delete_' + product).parentElement.classList.toggle(toggleclass);
            document.querySelector('html').classList.toggle('dialogOpen');
        });
    });
    //anderes Land einblenden
    document.querySelector('.field_country select')?.addEventListener('change', function() {
        var fieldCountry = this.closest('.field_country');
        var fieldForeignCountry = fieldCountry.nextElementSibling;
        var selectedOption = this.options[this.selectedIndex];
        var val = selectedOption.dataset.trigger;

        if (val === 'field_foreign_country') {
            fieldForeignCountry.style.display = 'block';
        } else {
            fieldForeignCountry.style.display = 'none';
        }
    });

    const selectElement = document.querySelector('.field_country select');
    if(selectElement) {
        const selectedOption = selectElement.options[selectElement.selectedIndex];
        const dataTrigger = selectedOption.dataset.trigger;

        // Step 3: Check if the data-trigger attribute value is 'field_foreign_country'
        if (dataTrigger === 'field_foreign_country') {
            // Step 4: Show the element with the class .field_foreign_country
            const foreignCountryField = document.querySelector('.field_foreign_country');
            foreignCountryField.style.display = 'block';
        }
    }

});
