class IgShopProductComparisonHandler {
    constructor() {
        this.linkButtonTextSelector = '.link-button-text';
        this.ajaxLoaderSelector = '.ajax-loader';
        this.addProductLinkElement = document.querySelector('.igshop2-add-to-product-comparison-link');
        this.countWrapperElement = document.querySelector('.tx-igshop2-product-comparison-small');
        this.countTextElement = this.countWrapperElement ? this.countWrapperElement.querySelector('.igshop-product-comparison-count-text') : null;
        this.compareUrlElements = document.querySelectorAll('.shop-compare-lightbox-link');
        this.addProductLinkButtonTextElement = this.addProductLinkElement ? this.addProductLinkElement.querySelector(this.linkButtonTextSelector) : null;
        this.addProductAjaxLoaderElement = this.addProductLinkElement ? this.addProductLinkElement.querySelector(this.ajaxLoaderSelector) : null;
        this.productComparisonListElement = document.querySelector('.product-comparison-list');
        this.dropdownElement = document.querySelector('.product-comparison-dropdown');
        this.dropdownTextElement = this.dropdownElement ? this.dropdownElement.querySelector('.shop-compare-text') : null;
        this.comparisonLinkElement = document.querySelector('.tx-igshop2-product-comparison-small > a');
        this.headerElement = document.getElementById('header');
        this.resetLink = document.querySelector('.products-compare-reset');
        this.closeLink = document.querySelector('.products-compare-close');
        this.stickyHeaderElement = document.querySelector('.productComparisonWrap.sticky-header .compare-line');
        this.firstLineElement = document.querySelector('.compare-line.first-line');
        this.headerElement = document.querySelector('header');
        this.btnR = document.querySelector('.btn-right');
        this.btnL = document.querySelector('.btn-left');
        this.tracks = document.querySelector('.compare-table');
        this.compareLine = this.tracks ? this.tracks.querySelector('.compare-line') : null;
        this.colContent = this.compareLine ? this.compareLine.querySelector('.col-content') : null;
        this.lightbox = null;
        this.count = 0;
    }

    init() {
        if(this.countWrapperElement) {
            this.initProductCount();
        }
        if(this.addProductLinkElement) {
            this.addProductLinkElement.addEventListener('click', (e) => {
                e.preventDefault();

                this.addProduct();
            });
        }
        document.addEventListener('click', (e) => {
            let target = e.target.closest('.product-comparison-dropdown');
            if(!target) {
                this.hideDropdown();
            }
        });
        if(this.comparisonLinkElement) {
            this.comparisonLinkElement.addEventListener('click', (e) => {
                let compareProductsElement = document.querySelector('.compare-products');
                localStorage.setItem('igshop2ProductComparisonReturnUrl', location.href);
                if(this.count < 2 || compareProductsElement) {
                    e.preventDefault();
                }
            });
        }
        if(this.resetLink) {
            this.resetLink.addEventListener('click', (e) => {
                e.preventDefault();
                let compareWrapper = document.querySelector('.igshop-product-comparison-wrapper');
                window.location.href = compareWrapper.dataset.resetLink;
            });
        }
        if(this.closeLink) {
            this.closeLink.addEventListener('click', (e) => {
                e.preventDefault();
                let closeLink = localStorage.getItem('igshop2ProductComparisonReturnUrl');
                window.location.href = closeLink;
            });
        }
        if(this.btnL && this.btnR) {
            this.initScrollButtons();
        }
        if(this.stickyHeaderElement && this.firstLineElement) {
            this.initStickyHeader();
        }
    }

    initProductCount() {
        let fetchProductsUrl = this.countWrapperElement.dataset.fetchProductsUrl;
        if(fetchProductsUrl) {
            let promise = null;
            let persistedProductComparisonUid = localStorage.getItem('igshopProductComparisonUid');
            if(persistedProductComparisonUid) {
                let requestData = new URLSearchParams({"tx_igshop2_productcomparison[productComparison]": persistedProductComparisonUid});
                promise = fetch(fetchProductsUrl, {method: 'POST', body: requestData});
            } else {
                promise = fetch(fetchProductsUrl, {method: 'POST'});
            }
            promise.then((response) => {
                return response.json();
            })
            .then((data) => {
                if(data.productComparisonUid) {
                    localStorage.setItem('igshopProductComparisonUid', data.productComparisonUid);
                }
                this.updateCount(data.productCount);
                this.updateCompareUrl(data.compareUrl);
            });
        }
    }

    addProduct() {
        let addProductUrl = this.addProductLinkElement.href;
        if(addProductUrl) {
            this.showAddProductAjaxLoader();
            
            let promise = null;
            let persistedProductComparisonUid = localStorage.getItem('igshopProductComparisonUid');
            
            if(persistedProductComparisonUid) {
                let requestData = new URLSearchParams({"tx_igshop2_productcomparison[productComparison]": persistedProductComparisonUid});
                promise = fetch(addProductUrl, {method: 'POST', body: requestData});
            } else {
                promise = fetch(addProductUrl, {method: 'POST'});
            }

            promise.then((response) => {
                return response.json();
            })
            .then((data) => {
                if(data.productComparisonUid) {
                    localStorage.setItem('igshopProductComparisonUid', data.productComparisonUid);
                }

                this.updateCount(data.productCount);
                this.updateCompareUrl(data.compareUrl);
                this.updateDropdown(data.html);
                this.showDropdown();

                this.hideAddProductAjaxLoader();
            });
        }
    }

    showAddProductAjaxLoader() {
        if(this.addProductAjaxLoaderElement) {
            this.addProductAjaxLoaderElement.style.display = '';
            this.addProductLinkButtonTextElement.style.visibility = 'hidden';
        }
    }

    hideAddProductAjaxLoader() {
        if(this.addProductAjaxLoaderElement) {
            this.addProductAjaxLoaderElement.style.display = 'none';
            this.addProductLinkButtonTextElement.style.visibility = '';
        }
    }

    // TODO: Analog zu smallFeCart Liste ausgeben und count aktualisieren
    updateView(html) {
        if(this.productComparisonListElement) {
            this.productComparisonListElement.innerHTML = html;
        }
    }

    updateCount(count) {
        this.count = count;
        if(this.countTextElement) {
            this.countTextElement.textContent = count;
        }
    }

    updateCompareUrl(compareUrl) {
        if(this.compareUrlElements) {
            this.compareUrlElements.forEach(function(compareUrlElement) {
                localStorage.setItem('igshop2ProductComparisonReturnUrl', location.href);
                compareUrlElement.href = compareUrl;
            });
        }
    }

    updateDropdown(html) {
        if(this.dropdownTextElement) {
            this.dropdownTextElement.innerHTML = html;
        }
    }

    showDropdown() {
        if(this.dropdownElement) {
            this.dropdownElement.classList.add('show');
        }
    }

    hideDropdown() {
        if(this.dropdownElement) {
            this.dropdownElement.classList.remove('show');
        }
    }
    
    initStickyHeader() {
        smartScroll((e) => {
            var offsetTop = this.firstLineElement.offsetTop;
            if(this.headerElement) {
                offsetTop -= this.headerElement.clientHeight;
            }
            if(window.scrollY > offsetTop) {
                this.showStickyHeader();
            } else {
                this.hideStickyHeader();
            }

            if(this.tracks.getBoundingClientRect().bottom < this.stickyHeaderElement.scrollHeight) {
                this.hideStickyHeader();
            }
        });
    }

    showStickyHeader() {
        if(this.stickyHeaderElement) {
            this.stickyHeaderElement.classList.add('sticky');
        }
    }

    hideStickyHeader() {
        if(this.stickyHeaderElement) {
            this.stickyHeaderElement.classList.remove('sticky');
        }
    }

    initScrollButtons()
    {
        this.updateScrollButtons();
        
        this.btnL.addEventListener('click', (e) => {
            e.preventDefault();
            const scrollWidth = this.colContent.scrollWidth;
            this.tracks.scrollBy({
                left: -scrollWidth,
                behavior: 'smooth'
            });
        });

        this.btnR.addEventListener('click', (e) => {
            e.preventDefault();
            const scrollWidth = this.colContent.scrollWidth;
            this.tracks.scrollBy({
                left: scrollWidth,
                behavior: 'smooth'
            });
        });

        this.tracks.addEventListener('scrollend', (e) => {
            this.updateScrollButtons();
        });

        smartresize((e) => {
            this.updateScrollButtons();
        });
    }

    updateScrollButtons() {
        const compareLineTrackWidth = this.compareLine.scrollWidth;
        const compareLineOverflowWidth = this.compareLine.offsetWidth;
        const scrollLeft = this.tracks.scrollLeft;

        this.btnL.classList.remove('show');
        this.btnR.classList.remove('show');
        this.btnR.classList.remove('disabled');
        this.btnL.classList.remove('disabled');

        if(compareLineTrackWidth > compareLineOverflowWidth) {
            this.btnL.classList.add('show');
            this.btnR.classList.add('show');
        }
        
        if(scrollLeft + compareLineOverflowWidth >= compareLineTrackWidth) {
            this.btnR.classList.add('disabled');
        }
        if(scrollLeft <= 0) {
            this.btnL.classList.add('disabled');
        }
    }

}


let igShopProductComparisonHandler = new IgShopProductComparisonHandler();
igShopProductComparisonHandler.init();

document.addEventListener("DOMContentLoaded", function(e) {
    if (typeof ScrollMirror !== 'undefined') {
        new ScrollMirror(document.querySelectorAll(".syncscroll"), {
            vertical: false,
            horizontal: true,
            proportional: true
        });
    }
});