document.addEventListener('DOMContentLoaded', function() {
    // Select all elements with the class "dropdown_content" inside ".igshop_detail_options"
    function resizeDropdownContent() {
        [...document.querySelectorAll(".igshop_detail_options .dropdown_content")].map(function(dropdownContent) {
            // Find the parent element and then the child element with class "dropdown_header"
            var dropdownHeader = dropdownContent.parentElement.querySelector("div.dropdown_header");
            // Set the width of the dropdownContent
            dropdownContent.style.width = (dropdownHeader.getBoundingClientRect().width - 18) + "px";
        });
    }
    function validateForm(form) {
        let isValid = true;
	let firstInvalidElement = null;
        const fields = form.querySelectorAll('input[data-required="1"], select[data-required="1"]');

        fields.forEach(field => {
            const targetElement = field.dataset.addToId ? document.getElementById(field.dataset.addToId) : null;
            if (!field.value.trim()) {
                isValid = false;
                field.classList.add('error'); // Add an error class if needed
                if (targetElement) {
		    targetElement.classList.add('error'); // Add error class to the target element
		    if (!firstInvalidElement) {
			firstInvalidElement = targetElement; // Set focus to targetElement first
                    }
                } else {
		    if (!firstInvalidElement) {
			firstInvalidElement = field; // Otherwise, set focus to the field itself
                    }
		}
            } else {
                field.classList.remove('error'); // Remove error class if field is valid
                if (targetElement) {
		    targetElement.classList.remove('error'); // Remove error class from the target element
                }
	    }
        });
	if (firstInvalidElement) {
            firstInvalidElement.focus(); // Set focus to the first invalid element
	}
        return isValid;
    }

    resizeDropdownContent();
    smartresize(resizeDropdownContent);

    [...document.querySelectorAll('.prodOptionSelect')].map(function(element) {
        element.addEventListener('click', function() {
            var curUid = element.getAttribute('data-uid');
            var curText = element.textContent;

            var parent = element.parentElement.parentElement; // Adjust the selector if .dropdown isn't the closest common parent

            parent.querySelector('.dropdown_action_label').textContent = curText;
            element.parentElement.querySelector('input').value = curUid;

            parent.querySelector('.dropdown_header').classList.toggle('active');
            
            var arrow = parent.querySelector('.dropdown_action_arrow');
            arrow.classList.remove('dropdown_action_close_arrow', 'dropdown_action_open_arrow');
            arrow.classList.add('dropdown_action_open_arrow');
        });
    });

    [...document.querySelectorAll('.header_popup_priceOptions .prodOptionSelect')].map(function(element) {
        element.addEventListener('click', function() {
            var price = this.dataset.price;
            var priceEuro = this.dataset.priceEuro;
            var priceElement = document.querySelector('.igShop-single-price .price .price_1');
            var priceEuroElement = document.querySelector('.igShop-single-price .price .price_2');
            if(priceElement) {
                priceElement.innerHTML = price;
            }
            if(priceEuroElement) {
                priceEuroElement.innerHTML = priceEuro;
            }
        });
    });

    [...document.querySelectorAll('.submit_product')].map(function(button) {
        button.addEventListener('click', function(event) {
            event.preventDefault();

            var productForm = button.closest('.product_form');
	    // Validate form
            if (!validateForm(productForm)) {
		var errorText = button.dataset.errorRequiredText;
		toastr.error(errorText);
		return;
            }
            var openCart = parseInt(button.dataset.openCart);
            var successText = button.dataset.successText;
            var addCartText = button.querySelector('.add-cart-text');
            var ajaxLoader = button.querySelector('.ajax-loader');

            if (addCartText && ajaxLoader) {
                addCartText.style.visibility = 'hidden';
                ajaxLoader.style.display = 'block';
            }
	    
	    var formData = new FormData(productForm);
            var searchParams = new URLSearchParams(formData);
            var url = addProductUrl; // Replace with your actual URL
	    
            fetch(url, {
                method: 'POST',
                body: searchParams
            })
            .then(function(response) {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                return response.text();
            })
            .then(function(data) {
                if (typeof igShopSmallCarts !== 'undefined' && igShopSmallCarts.length) {
                    igShopSmallCarts.forEach(function(smallCart) {
                        smallCart.update(function() {
                            if(addCartText && ajaxLoader) {
                                addCartText.style.visibility = 'visible';
                                ajaxLoader.style.display = 'none';
                            }
                            if (openCart) {
                                smallCart.open();
                            }
                            if (successText) {
                                toastr.success(successText);
                            }
                        });
                    });
                } else {
                    if(typeof igShopAjaxCounts !== 'undefined' && igShopAjaxCounts.length) {
                        igShopAjaxCounts.forEach(function(ajaxCount) {
                            ajaxCount.update();
                        });
                    }
                    if(addCartText && ajaxLoader) {
                        addCartText.style.visibility = 'visible';
                        ajaxLoader.style.display = 'none';
                    }
                    if (successText) {
                        toastr.success(successText);
                    }
                }
            })
            .catch(function(error) {
                console.error('Fetch error:', error);
            });

            return false;
        });
    });

    [...document.querySelectorAll('.optionProducts')].map(function(product) {
        var checkboxes = product.querySelectorAll('input[type="checkbox"]');
        var maxAmount = parseInt(product.dataset.maxAmount, 10);

        checkboxes.forEach(function(checkbox) {
            checkbox.addEventListener('click', function(e) {
                var checked = product.querySelectorAll('input[type="checkbox"]:checked');
                if (checked.length > maxAmount) {
                    checkbox.checked = false;
                }
            });
        });
    });

    // Select the elements with the specified classes
    [...document.querySelectorAll('.igshop-openAddressDeletePopup, .igshop-closeAddressDeletePopup')].map(function(element) {
        // Add click event listener to each element
        element.addEventListener('click', function(e) {
            e.preventDefault(); // Prevent default action of the click event
        });
    });


    // TODO: Kein jQuery
    // Selecting elements with vanilla JS
    [...document.querySelectorAll(".igshop_detail_options .dropdown_header, .filterForm .dropdown_header")].map(function(header) {
        header.addEventListener('click', function(e) {
            // Toggle active class
            if (this.classList.contains('active')) {
                this.querySelector(".dropdown_action_arrow")
                    .classList.remove("dropdown_action_close_arrow", "dropdown_action_open_arrow");
                this.querySelector(".dropdown_action_arrow")
                    .classList.add("dropdown_action_open_arrow");
                this.nextElementSibling.classList.remove('show');
            } else {
                this.querySelector(".dropdown_action_arrow")
                    .classList.remove("dropdown_action_open_arrow", "dropdown_action_close_arrow");
                this.querySelector(".dropdown_action_arrow")
                    .classList.add("dropdown_action_close_arrow");
                this.nextElementSibling.classList.add('show');
            }
            this.classList.toggle('active');
        });
    });
    // Selecting elements with class 'dropdown_header' inside '.igshop_detail_options' and elements with class 'prodOptionSelect'
    [...document.querySelectorAll(".igshop_detail_options .dropdown_header, .prodOptionSelect")].map(function(element) {
        // Adding click event listener to each selected element
        element.addEventListener("click", function() {
            // Finding closest ancestor with class 'igShop-single-option' and selecting its siblings
            var siblings = this.closest(".igShop-single-option").parentNode.children;
            // Iterating through siblings
            Array.prototype.forEach.call(siblings, function(sibling) {
                var dropdownHeader = sibling.querySelector('.dropdown_header');
                if(dropdownHeader && dropdownHeader != element) {
                    // Removing and adding classes to elements within each sibling
                    sibling.querySelector(".dropdown_action_arrow")?.classList.remove("dropdown_action_close_arrow");
                    sibling.querySelector(".dropdown_action_arrow")?.classList.remove("dropdown_action_open_arrow");
                    sibling.querySelector(".dropdown_action_arrow")?.classList.add("dropdown_action_open_arrow");
                    sibling.querySelector(".dropdown_content")?.classList.remove('show');
                    dropdownHeader?.classList.remove('active');
                }
            });
        });
    });

    document.addEventListener('click', (e) => {
        [...document.querySelectorAll(".dropdown_header")].map(function(select) {
            var dropdownContent = select.parentElement.querySelector('.dropdown_content');
            if(!select.contains(e.target) && !dropdownContent.contains(e.target)) {
                let arrow = select.querySelector('dropdown_action_arrow');
                if(arrow) {
                    select.querySelector(".dropdown_action_arrow").classList.remove("dropdown_action_close_arrow");
                    select.querySelector(".dropdown_action_arrow").classList.remove("dropdown_action_open_arrow");
                    select.querySelector(".dropdown_action_arrow").classList.add("dropdown_action_open_arrow");
                }
                dropdownContent.classList.remove('show');
                select.classList.remove('active');
            }
        });
    });

    //let slider = document.querySelector('.ig-splide-slider').splideInstance.slider;

    let slider = document.querySelector('#product_detail_images_gallery .ig-slider')?.splideInstance.slider;
    let sliderThumbs = document.querySelectorAll('.thumb_container .thumb');
    let currentSlide = sliderThumbs[0];
    sliderThumbs?.forEach(sliderThumb => {
        sliderThumb.addEventListener('click', () => {
            event.preventDefault();
            slider.go(parseInt(sliderThumb.dataset.thumbid));
            //console.log('slider.go: ', parseInt(sliderThumb.dataset.thumbid) , sliderThumb.dataset.thumbid);
        });
    });

   slide?.on('move', function () {
        if ( currentSlide ) {
            currentSlide.style.opacity = '0.6';
        }

        // Splide#index returns the latest slide index:
        var thumbnail = sliderThumbs[ slider.index ];

        if ( thumbnail ) {
            thumbnail.style.opacity = '1';
            currentSlide = thumbnail;
        }
    });
});
