class IgShopAmountInput {
    constructor(inputElement) {
        this.inputElement = inputElement;
        this.minusElement = inputElement.parentElement.querySelector('.amountInputMinus');
        this.plusElement = inputElement.parentElement.querySelector('.amountInputPlus');
        this.minAmount = parseInt(inputElement.dataset.minAmount);
        this.maxAmount = parseInt(inputElement.dataset.maxAmount);
        this.editAmountFormElement = this.inputElement.closest('.editAmountForm');
        this.productPriceElement = this.editAmountFormElement?.closest('.productrows').querySelector('.price ');
        this.productTotalPriceElement = this.editAmountFormElement?.closest('.productrows').querySelector('.total_price ');
        this.productQuantityInput = inputElement.parentElement.querySelector('.amountInput');
        this.totalPriceElement = document.querySelector('.product_list_bottom .total_price');
        this.totalAmountElement = document.querySelector('#header_cart_products_amount');
        this.portoFreeTextElement = document.querySelector('.product_list_bottom_until_portofree');
        this.smallFeCartTotalElement = document.querySelector('#small_fe_price_total');
    }

    init() {
        if(isNaN(this.minAmount) || this.minAmount == 0) {
            this.minAmount = 1;
        }
        if(isNaN(this.maxAmount) || this.maxAmount == 0) {
            this.maxAmount = 99999999999;
        }
        this.inputElement.addEventListener('change', this.onInputChange.bind(this));
        this.minusElement.addEventListener('click', this.onMinusClick.bind(this));
        this.plusElement.addEventListener('click', this.onPlusClick.bind(this));
        if(this.editAmountFormElement) {
            this.editAmountFormElement.addEventListener('submit', (event) => {
                event.preventDefault();
            });
        }
    }

    onInputChange(event) {
        var amount = parseInt(this.inputElement.value);
		if(isNaN(amount) || parseInt(amount) < this.minAmount){
            this.inputElement.value = this.minAmount;
		} else if(amount > this.maxAmount){
            this.inputElement.value = this.maxAmount;
        }
        this.submitEditAmountForm();
    }

    onMinusClick(event) {
		var amount = parseInt(this.inputElement.value);
		if(isNaN(amount)){
			amount = this.minAmount;
		}
        amount -= 1;
		if(amount < this.minAmount){
            amount = this.minAmount;
		}
        this.inputElement.value = amount;
        this.submitEditAmountForm();
    }

    onPlusClick(event) {
		var amount = parseInt(this.inputElement.value);
		if(isNaN(amount)){
			amount = this.minAmount;
		}
        amount += 1;
		if(amount > this.maxAmount){
			amount = this.maxAmount;
		}
        this.inputElement.value = amount;
        this.submitEditAmountForm();
    }

    submitEditAmountForm() {
        if(!this.editAmountFormElement) {
            return;
        }

        this.inputElement.classList.add('show-ajax-loader');

        var url = this.editAmountFormElement.action;

        let formData = new FormData(this.editAmountFormElement);
        const requestData = new URLSearchParams(formData);

        let promise = fetch(url, {method: 'POST', body: requestData});
        promise.then((response) => {
            return response.json();
        })
        .then(this.updateEditAmountForm.bind(this));
    }

    updateEditAmountForm(data) {
        let product = data.product;
        let total = data.total;
        if(this.productPriceElement) {
            this.productPriceElement.innerHTML = product.price;
        }
        if(this.productTotalPriceElement) {
            this.productTotalPriceElement.innerHTML = product.amount;
        }
        if(this.totalPriceElement) {
            this.totalPriceElement.innerHTML = total.amount;
        }
        if(this.portoFreeTextElement) {
            this.portoFreeTextElement.innerHTML = total.portoText;
        }
        if(this.totalAmountElement) {
            this.totalAmountElement.innerHTML = total.quantity;
        }
        if(this.productQuantityInput && product.quantity) {
            this.productQuantityInput.value = product.quantity;
        }
        if(this.smallFeCartTotalElement) {
            this.smallFeCartTotalElement.innerHTML = total.quantity;
        }
        this.inputElement.classList.remove('show-ajax-loader');
        this.updateSmallCart();
    }
    
    updateSmallCart() {
        if(typeof igShopSmallCarts !== 'undefined') {
            igShopSmallCarts.forEach(function(smallCart) {
                smallCart.update();
            });
        } else if(typeof igShopAjaxCounts !== 'undefined') {
            igShopAjaxCounts.forEach(function(ajaxCount) {
                ajaxCount.update();
            });
        }
    }
}

var igShopAmountInputs = [];
[...document.querySelectorAll('input.amountInput')].map(function(amountInput) {
    let igShopAmountinput = new IgShopAmountInput(amountInput);
    igShopAmountinput.init();
    igShopAmountInputs.push(igShopAmountinput);
});
