var wordSearch = false;



document.getElementById('indexedsearch')?.addEventListener('submit', function(e) {
    var shopSearchString = document.querySelector('.shopSearchString');
    var shopAjaxSearch = document.querySelector('input.shop-ajax-search').value;
    if (!wordSearch) {
        shopSearchString.value = shopAjaxSearch;
    } else {
        shopSearchString.value = '';
    }
});

document.addEventListener('DOMContentLoaded', function() {
    if (document.querySelector('input.shop-ajax-search')) {
        initIndexSearchAutocomplete();
    }
});

var indexedSearchAutocompleteDebounceInterval = null; // Used to reduce the amount of querys
function initIndexSearchAutocomplete() {
    
    var searchInput = document.querySelector('input.shop-ajax-search');
    //searchInput.addEventListener('keypress', indexedSearchAutocomplete);
    searchInput.addEventListener('keyup', indexedSearchAutocomplete);
    searchInput.setAttribute('autocomplete', 'off');


    var searchButton = document.querySelector('.searchButton');
    var searchBox = document.querySelector('.searchBox');
    var searchContent = document.querySelector('.searchContent');
    var deleteClassesOnOpen = searchButton.dataset['deleteclasses'];
    var hideClassesOnOpen = searchButton.dataset['hideclasses'];

    
    function handleSearchBoxClick(event) {
        const isClickInside = searchContent.firstElementChild.contains(event.target) || searchButton.contains(event.target);
        if (!isClickInside) {
            searchContent.style.display = 'none';
	    searchBox.classList.remove('search-open');
            document.removeEventListener('click', handleSearchBoxClick);
	    event.preventDefault();
            event.stopPropagation();
        }
    }

    searchButton.addEventListener('click', function () {
        if (searchContent.style.display === 'none' || searchContent.style.display === '') {
            searchContent.style.display = 'block';
	    searchBox.classList.add('search-open');
	    document.addEventListener('click', handleSearchBoxClick);
	    if (hideClassesOnOpen) {
		var classesToHide = hideClassesOnOpen.split(',').map(function(item) {
                    return item.trim();
		});
		classesToHide.forEach(function(className) {
                    var elements = document.querySelectorAll(className);
                    elements.forEach(function(element) {
			element.style.display = 'none';
                    });
		});
	    }
	    if (deleteClassesOnOpen) {
                cmdConfig = deleteClassesOnOpen.split('|');
		if (cmdConfig.length > 1) {
		    let cmdElement = document.querySelector(cmdConfig[0]);
		    if (cmdElement && cmdElement.classList.contains('open')) {
			cmdElement.classList.remove('open');
		    }
                    //this.changeElementAttributes(deleteClassesOnOpenElements, "removeClass");
		}
            }

        } else {
            searchContent.style.display = 'none';
	    searchBox.classList.remove('search-open');
	    document.removeEventListener('click', handleSearchBoxClick);
        }
    });
}

var indexedSearchAutocompleteDebounceInterval = null; // Used to reduce the number of queries

function indexedSearchAutocomplete(e) {
    var inputElem = e.target;
    var elem = e.target;
    var results;
    const Template = function (
        product
    ) {
	const numberFormat = new Intl.NumberFormat('de-CH', {
            style: 'currency',
            currency: 'CHF',
            minimumFractionDigits: 2,
            maximumFractionDigits: 2
	});

	var imageHtml = (product.image && product.image[0] ? '<img src="' + product.image[0] + '" width="80" />' : '');
	
	if (product.hasPromoPrice) {
	    var priceHtml =  '<div class="promoPrice">' + numberFormat.format(product.price) + '</div><div class="origPrice hasPromoPrice">' + numberFormat.format(product.origPrice) + '</div>';
	    if (product.discount > 0) {
		imageHtml += '<div class="product-discount-amount"><div class="product-discount-amount-inner">' + product.discount + '%</div></div>';

	    } else {
		imageHtml += '<img class="aktion_preis_image detailView" alt="' + product.badge.alt + '" src="' + product.badge.img + '" width="30" height="30">';
	    }
	    
	} else {
	    var priceHtml =  numberFormat.format(product.price);
	}
        return '<div class="image-text-container flex">'
            + ' <div class="col-image flex-col">' + imageHtml + '</div>'
            + '<div class="col-info flex-col">'
            + '<div class="price flex">' + priceHtml  + '</div>'
            + '<div class="name"><a href="' + product.showUrl + '">' + product.name + '</a></div>'
            + '<div class="info">' + product.productid + '</div>'
            + '</div>'
            + '</div>';
    }

    
    while (elem.tagName !== 'HTML') {
        results = elem.querySelector('.search-autocomplete-results');
        if (results) {
            break;
        }
        elem = elem.parentElement;
    }

    if (elem.tagName === 'HTML') {
        console.log("we couldn't find a result div (.search-autocomplete-results)");
        return;
    }

    var mode = results.dataset.mode === undefined ? 'word' : results.dataset.mode;
    var soc = results.dataset.searchonclick === 'true';

    if (e.type !== 'keyup') {
        return;
    }

    results.innerHTML = '';
    results.classList.remove('results');
    results.classList.add('no-results');

    var val = inputElem.value;
    var name = inputElem.getAttribute('name');
    var minlen = results.dataset.minLength === undefined ? 3 : parseInt(results.dataset.minLength, 10);
    var maxResults = results.dataset.maxResults === undefined ? 5 : parseInt(results.dataset.maxResults, 5);
    var countLabel = results.dataset.maxResults === undefined ? 'Gefundene Produkte: [count]' : results.dataset.countLabel;
    if (val.length < minlen) {
        return;
    }

    results.classList.add('autocomplete_searching');

    // Debounce
    clearInterval(indexedSearchAutocompleteDebounceInterval);
    indexedSearchAutocompleteDebounceInterval = setInterval(function() {
        clearInterval(indexedSearchAutocompleteDebounceInterval);

        //var basename = name.includes('tx_igshop2_fesearchbox') ? 'tx_igshop2_fesearchbox' : 'tx_igshop2_feshop';
        var basename = 'tx_igshop2_feshop';
	/*
        var formData = {};
        formData[basename] = {
            searchword: val
        };
	*/
	var formData = new FormData();
	formData.append(basename + '[searchString]', val);
	formData.append(basename + '[search][maxResults]', maxResults);
        // Execute the query
        fetch(results.dataset.searchurl, {
            method: 'POST',
            body: formData,
            cache: 'no-cache'
        })
        .then(response => response.json())
        .then(data => {
 
            var products = data.products;
	    var html = '';
	    products.forEach(function(product) {
		html += Template(product);
	    });
            results.style.display = 'block';
            results.innerHTML = '<div class="igshop-search-ajax-results">'
		+ '<div class="count">' + countLabel.replace('[count]', data.count) + '</div>'
		+ '<div class="products">' + html + '</div>'
		+ '</div>';
            results.classList.remove('autocomplete_searching');
	    /*
	    var products = results.querySelectorAll('.ajax-product');
            if (products.length) {
                document.getElementById('indexedsearch').setAttribute('action', document.getElementById('indexedsearch').dataset.shopSearchUrl);
                document.getElementById('indexedsearch').setAttribute('method', 'get');
                wordSearch = false;
            } else {
                document.getElementById('indexedsearch').setAttribute('action', document.getElementById('indexedsearch').dataset.indexedSearchUrl);
                document.getElementById('indexedsearch').setAttribute('method', 'post');
                wordSearch = true;
            }

            var words = results.querySelectorAll('.ajax-word a');
            words.forEach(function(word) {
                word.addEventListener('click', function(e) {
                    e.preventDefault();
                    inputElem.value = this.textContent.trim();
                    wordSearch = true;
                    document.getElementById('indexedsearch').setAttribute('method', 'post');
                    document.getElementById('indexedsearch').setAttribute('action', document.getElementById('indexedsearch').dataset.indexedSearchUrl);
                    document.getElementById('indexedsearch').submit();
                });
            });

            var allProductsLinks = results.querySelectorAll('.ajax-all-products a');
            allProductsLinks.forEach(function(link) {
                link.addEventListener('click', function(e) {
                    e.preventDefault();
                    this.closest('form').submit();
                });
            });

            var categories = results.querySelectorAll('.ajax-category');

            if (!words.length && !products.length && !categories.length) {
                results.classList.remove('results');
                results.classList.add('no-results');
            } else {
                results.classList.remove('no-results');
                results.classList.add('results');
            }
	    */
        });
    }, 250);
}
