


class IndexSearchAutoComplete {
    constructor(indexedsearchElements) {
        this.indexedsearchElements = indexedsearchElements;
        this.debounceTimeout = null; // Used to reduce the amount of querys
        this.lastSearchQuery = ''; // Used to reduce the amount of querys
        this.results;
        this.init();
    }
    init() {
        this.indexedsearchElements.forEach((input) => {
            input.addEventListener('keypress', (e) => {
                this.autocomplete(e, input);
            });
            input.addEventListener('keyup', (e) => {
                this.autocomplete(e, input);
            });

            // Set autocomplete attribute to off
            input.setAttribute('autocomplete', 'off');
        });
        // Attach a click event listener to the document object
        document.addEventListener('click', function (event) {
            const targetClass = 'search-autocomplete-results';
            const targetElems = document.querySelectorAll('.' + targetClass + ' > *');

            // If the autocomplete box is not visible, do nothing
            if (targetElems.length === 0) {
                return;
            }

            let elem = event.target;

            // Traverse up the DOM tree until an element with the target class is found or the HTML element is reached
            while (elem.tagName !== 'HTML' && !elem.classList.contains(targetClass)) {
                elem = elem.parentNode;
            }

            // If the clicked element is outside the autocomplete box, hide the box and clear its contents
            if (elem.tagName === 'HTML') {
                targetElems.forEach(function (targetElem) {
                    targetElem.innerHTML = '';
                    targetElem.classList.remove('results');
                    targetElem.classList.add('no-results');
                    targetElem.style.display = 'none';
                });
            }
        });
    }
    autocomplete(e, reference) {
        let inputElement = reference;
        let elem = inputElement;


        while (elem.tagName !== 'HTML') {
            // get the first element
            this.results = elem.getElementsByClassName('search-autocomplete-results');
            if (this.results.length > 0) {
                this.results = this.results[0];
                break;
            }
            elem = elem.parentNode;
        }
        if (elem.tagName === 'HTML') {
            console.log("we couldn't find a result div (.search-autocomplete-results)");
            return;
        }

        // Retrive options
        let mode = typeof this.results.dataset.mode === 'undefined' ? 'word' : this.results.dataset.mode;
        let soc = Boolean(this.results.dataset.searchonclick) == true;

        // navigate through the suggestions/results
        if (e.which === 38 || e.which === 40 || e.keyCode === 10 || e.keyCode === 13) { // up / down / enter

            if (e.which === 38 && e.type === 'keyup') { // up
                var prev = this.results.querySelector('li.highlighted')?.previousElementSibling;

                if (!this.results.querySelector('li.highlighted') || !prev) {
                    this.results.querySelector('li.highlighted')?.classList.remove('highlighted');
                    this.results.querySelector('li:last-child')?.classList.add('highlighted');
                    return;
                }

                this.results.querySelector('li.highlighted').classList.remove('highlighted');
                prev.classList.add('highlighted');
            }

            if (e.which === 40 && e.type === 'keyup') { // down
                let next = this.results.querySelector('li.highlighted')?.nextElementSibling;

                if (!this.results.querySelector('li.highlighted') || !next) {
                    this.results.querySelector('li.highlighted')?.classList.remove('highlighted');
                    this.results.querySelector('li:first-child')?.classList.add('highlighted');
                    return;
                }

                this.results.querySelector('li.highlighted')?.classList.remove('highlighted');
                next.classList.add('highlighted');
            }

            if ((e.keyCode === 10 || e.keyCode === 13) && e.type === 'keypress') { // enter
                if (this.results.style.display !== 'none' && this.results.querySelector('li.highlighted')) {
                    if (mode === 'word') {
                        this.results.querySelector('li.highlighted').click();

                        // Search on click
                        if (soc) {
                            console.log(inputElement.closest('form'));
                            inputElement.closest('form').submit();
                        }
                    } else {
                        window.location = this.results.querySelector('li.highlighted a.navigate-on-enter')?.getAttribute('href');
                    }
                    e.preventDefault();
                }
            }

            return;
        }

        // Catch left / right arrow keys
        if (e.keyCode === 37 || e.keyCode === 39)
            return;

        // Do only start a query if a key is released to save querys
        if (e.type !== 'keyup')
            return;

        // Empty the results
        this.results.innerHTML = '';
        this.results.style.display = 'none';
        this.results.classList.remove('results');
        this.results.classList.add('no-results');

        // Retrive the query
        let val = reference.value.trim();
        let minlen = typeof this.results.dataset.minlength === 'undefined' ? 3 : this.results.dataset.minlength;
        let maxResults = typeof this.results.dataset.maxresults === 'undefined' ? 10 : this.results.dataset.maxresults;

        // Check if the query is long enough
        if (val.length < minlen)
            return;

        // Check whether the search term changed
        if (val == this.lastSearchQuery)
            return;

        // Set the old query value
        this.lastSearchQuery = val;

        // tell the user the search is running
        this.results.classList.add('autocomplete_searching');

        // Perform the query
        this.performQuery(val, mode, maxResults, this.results, inputElement);
    }
    performQuery(val, mode, maxResults, results, inputElement) {

        // Debounce
        clearTimeout(this.debounceTimeout);
        this.debounceTimeout = setTimeout(function () {
            clearTimeout(this.debounceTimeout);
            let xhr = new XMLHttpRequest();
            xhr.onreadystatechange = function () {
                if (xhr.readyState === 4 && xhr.status === 200) {
                    let data = xhr.responseText;
                    // Insert the results
                    results.style.display = 'block';
                    results.innerHTML = data;
                    results.classList.remove('autocomplete_searching');
                    let lis = results.getElementsByTagName('li');

                    // Add a click action
                    Array.from(lis).forEach(function (item) {
                        item.addEventListener('click', function () {
                            var text = this.textContent.trim();
                            inputElement.value = text;
                            results.innerHTML = '';
                            results.style.display = 'none';
                        });
                    });

                    // Check if there are results and update the FE depending on it
                    if (lis.length === 0) {
                        // No results
                        results.innerHTML = '';
                        results.style.display = 'none';
                        results.classList.remove('results');
                        results.classList.add('no-results');
                    } else {
                        // Results
                        results.classList.remove('no-results');
                        results.classList.add('results');
                    }
                }
            };

            xhr.open('POST', results.dataset.searchurl);
            xhr.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
            let params = 's=' + val + '&m=' + mode + '&mr=' + maxResults;
            xhr.send(params);
        }, 250);
    }
}
let indexedsearchElements = document.querySelectorAll('input.search, input.tx-indexedsearch-searchbox-sword, input.indexed-search-atocomplete-sword, input.indexed-search-autocomplete-sword');
if (indexedsearchElements.length) {
    new IndexSearchAutoComplete(indexedsearchElements);
}