<?php

namespace ID\IndexedSearchAutocomplete\Controller;

use ID\IndexedSearchAutocomplete\Service\SearchService;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
/**
 * SearchController
 *
 * This controller receives the search and handles them.
 */
class SearchController extends ActionController
{

    /**
     * Search functions
     *
     * @var SearchService
     */
    protected $searchService = null;

    public function injectSearchService(SearchService $searchService): void
    {
        $this->searchService = $searchService;
    }
    
    public function searchAction(): ResponseInterface
    {

        /**
         * Fetch the request, with parameters:
         * m: search mode 'word' or 'link'
         * s: search keyword
         * mr: max results
         */
        $arg = $_REQUEST;

        $searchMode = $arg['m'] ?? '';
        $searchKeywords = trim($arg['s'] ?? '');
        $searchMaxResults = (int) ($arg['mr'] ?? 0);


        $result = [];
        // Check which search to perform
        if ($searchKeywords !== '') {
            if ($searchMode === 'word') {
                $result = $this->searchService->searchAWord($searchKeywords, $searchMaxResults);
            } elseif ($searchMode === 'link') {
                $result = $this->searchService->searchASite($searchKeywords, $searchMaxResults);
            }
        }

        // Assign the results
        foreach ($result as $key => $value) {
            $this->view->assign($key, $value);
        }
        return $this->htmlResponse($this->view->render());        
    }
}
